/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkBranch;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

public final class PerkTreasureSeeker
extends Perk {
    public PerkTreasureSeeker(String name, PerkBranch branch, int branchTier, Supplier<ItemStack> icon) {
        super(name, branch, branchTier, icon);
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    @Nullable
    public Perk getParent() {
        return ModPerks.archaeologist;
    }

    @Override
    public Component getCurrentBonusInfo(int level) {
        return Component.literal((String)("+" + level * 20 + "% ")).append((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus")));
    }

    @Override
    public int getLevelBonus(Player player) {
        int n = player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.christmas_hat ? 2 : 0;
        return n + (switch (TimeHelper.getSpecialEvent()) {
            case TimeHelper.SpecialEvent.CHRISTMAS -> 5;
            case TimeHelper.SpecialEvent.HALLOWEEN, TimeHelper.SpecialEvent.SPRING_BLOOM -> 3;
            default -> 0;
        });
    }
}

