/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

@OnlyIn(value=Dist.CLIENT)
public class GraveGuardianCapeLayer
extends RenderLayer<GraveGuardian, SkeletonModel<GraveGuardian>> {
    private static final ResourceLocation CAPE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/block/cape.png");
    private final PlayerModel<AbstractClientPlayer> layerModel;

    public GraveGuardianCapeLayer(RenderLayerParent<GraveGuardian, SkeletonModel<GraveGuardian>> p_116602_, EntityModelSet entityModelSet) {
        super(p_116602_);
        this.layerModel = new PlayerModel(entityModelSet.bakeLayer(ModelLayers.PLAYER), false);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GraveGuardian graveGuardian, float p_116619_, float p_116620_, float p_116621_, float p_116622_, float p_116623_, float p_116624_) {
        ItemStack itemstack;
        if (!graveGuardian.isInvisible() && !(itemstack = graveGuardian.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA)) {
            float b;
            float g;
            float r;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.125f);
            double d0 = Mth.lerp((double)p_116621_, (double)graveGuardian.xCloakO, (double)graveGuardian.xCloak) - Mth.lerp((double)p_116621_, (double)graveGuardian.xo, (double)graveGuardian.getX());
            double d1 = Mth.lerp((double)p_116621_, (double)graveGuardian.yCloakO, (double)graveGuardian.yCloak) - Mth.lerp((double)p_116621_, (double)graveGuardian.yo, (double)graveGuardian.getY());
            double d2 = Mth.lerp((double)p_116621_, (double)graveGuardian.zCloakO, (double)graveGuardian.zCloak) - Mth.lerp((double)p_116621_, (double)graveGuardian.zo, (double)graveGuardian.getZ());
            float f = Mth.rotLerp((float)p_116621_, (float)graveGuardian.yBodyRotO, (float)graveGuardian.yBodyRot);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)p_116621_, (float)graveGuardian.oBob, (float)graveGuardian.bob);
            f1 += Mth.sin((float)(Mth.lerp((float)p_116621_, (float)graveGuardian.walkDistO, (float)graveGuardian.walkDist) * 6.0f)) * 32.0f * f4;
            if (graveGuardian.isCrouching()) {
                f1 += 25.0f;
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
            poseStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
            VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)this.getCloakTextureLocation()));
            if (TimeHelper.isDateAroundSpringBloom()) {
                r = 0.45f;
                g = 0.28f;
                b = 0.58f;
            } else if (TimeHelper.isDateAroundChristmas()) {
                r = 0.9f;
                g = 0.0f;
                b = 0.0f;
            } else if (TimeHelper.isDateAroundHalloween()) {
                r = 1.0f;
                g = 0.58f;
                b = 0.0f;
            } else {
                r = 0.0f;
                g = 0.41f;
                b = 0.45f;
            }
            this.layerModel.cloak.render(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, Helper.convertColorToInt(1.0f, r, g, b));
            poseStack.popPose();
        }
    }

    private ResourceLocation getCloakTextureLocation() {
        return CAPE_TEXTURE;
    }
}

