/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerBlock;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerContainer;
import net.silentchaos512.gear.block.alloymaker.screen.AlloyForgeScreen;
import net.silentchaos512.gear.block.alloymaker.screen.CrudeMixerScreen;
import net.silentchaos512.gear.block.alloymaker.screen.RecrystallizerScreen;
import net.silentchaos512.gear.block.alloymaker.screen.RefabricatorScreen;
import net.silentchaos512.gear.block.alloymaker.screen.SuperMixerScreen;
import net.silentchaos512.gear.block.charger.ChargerContainerMenu;
import net.silentchaos512.gear.block.charger.ChargerContainerScreen;
import net.silentchaos512.gear.block.grader.GraderContainer;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.block.press.MetalPressContainer;
import net.silentchaos512.gear.block.press.MetalPressScreen;
import net.silentchaos512.gear.block.salvager.SalvagerContainer;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainerMenu;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainerScreen;
import net.silentchaos512.gear.setup.SgBlocks;

public final class SgMenuTypes {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"silentgear");
    public static final DeferredHolder<MenuType<?>, MenuType<GraderContainer>> MATERIAL_GRADER = SgMenuTypes.register("material_grader", GraderContainer::new);
    public static final DeferredHolder<MenuType<?>, MenuType<MetalPressContainer>> METAL_PRESS = SgMenuTypes.register("metal_press", MetalPressContainer::new);
    public static final DeferredHolder<MenuType<?>, MenuType<AlloyMakerContainer>> METAL_ALLOYER = SgMenuTypes.register("metal_alloyer", (id, playerInventory, buffer) -> new AlloyMakerContainer(SgMenuTypes.getMetalAlloyer(), id, playerInventory, (FriendlyByteBuf)buffer, ((AlloyMakerBlock)((Object)((Object)SgBlocks.ALLOY_FORGE.get()))).getCategories()));
    public static final DeferredHolder<MenuType<?>, MenuType<AlloyMakerContainer>> RECRYSTALLIZER = SgMenuTypes.register("recrystallizer", (id, playerInventory, buffer) -> new AlloyMakerContainer(SgMenuTypes.getRecrystallizer(), id, playerInventory, (FriendlyByteBuf)buffer, ((AlloyMakerBlock)((Object)((Object)SgBlocks.RECRYSTALLIZER.get()))).getCategories()));
    public static final DeferredHolder<MenuType<?>, MenuType<AlloyMakerContainer>> REFABRICATOR = SgMenuTypes.register("refabricator", (id, playerInventory, buffer) -> new AlloyMakerContainer(SgMenuTypes.getRefabricator(), id, playerInventory, (FriendlyByteBuf)buffer, ((AlloyMakerBlock)((Object)((Object)SgBlocks.REFABRICATOR.get()))).getCategories()));
    public static final DeferredHolder<MenuType<?>, MenuType<AlloyMakerContainer>> CRUDE_MIXER = SgMenuTypes.register("crude_mixer", (id, playerInventory, buf) -> new AlloyMakerContainer(SgMenuTypes.getSuperMixer(), id, playerInventory, (FriendlyByteBuf)buf, List.of()));
    public static final DeferredHolder<MenuType<?>, MenuType<AlloyMakerContainer>> SUPER_MIXER = SgMenuTypes.register("super_mixer", (id, playerInventory, buf) -> new AlloyMakerContainer(SgMenuTypes.getSuperMixer(), id, playerInventory, (FriendlyByteBuf)buf, List.of()));
    public static final DeferredHolder<MenuType<?>, MenuType<SalvagerContainer>> SALVAGER = SgMenuTypes.register("salvager", SalvagerContainer::new);
    public static final DeferredHolder<MenuType<?>, MenuType<ChargerContainerMenu>> STARLIGHT_CHARGER = SgMenuTypes.register("starlight_charger", ChargerContainerMenu::createStarlightCharger);
    public static final DeferredHolder<MenuType<?>, MenuType<BlueprintBookContainerMenu>> BLUEPRINT_BOOK = SgMenuTypes.register("blueprint_book", BlueprintBookContainerMenu::new);

    private SgMenuTypes() {
    }

    private static <T extends AbstractContainerMenu> DeferredHolder<MenuType<?>, MenuType<T>> register(String name, IContainerFactory<T> factory) {
        return MENU_TYPES.register(name, () -> IMenuTypeExtension.create((IContainerFactory)factory));
    }

    private static MenuType<?> getMetalAlloyer() {
        return (MenuType)METAL_ALLOYER.get();
    }

    private static MenuType<?> getRecrystallizer() {
        return (MenuType)RECRYSTALLIZER.get();
    }

    private static MenuType<?> getRefabricator() {
        return (MenuType)REFABRICATOR.get();
    }

    private static MenuType<?> getSuperMixer() {
        return (MenuType)SUPER_MIXER.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)CRUDE_MIXER.get(), CrudeMixerScreen::new);
            event.register((MenuType)MATERIAL_GRADER.get(), GraderScreen::new);
            event.register((MenuType)METAL_ALLOYER.get(), AlloyForgeScreen::new);
            event.register((MenuType)METAL_PRESS.get(), MetalPressScreen::new);
            event.register((MenuType)RECRYSTALLIZER.get(), RecrystallizerScreen::new);
            event.register((MenuType)REFABRICATOR.get(), RefabricatorScreen::new);
            event.register((MenuType)SALVAGER.get(), SalvagerScreen::new);
            event.register((MenuType)STARLIGHT_CHARGER.get(), ChargerContainerScreen::new);
            event.register((MenuType)SUPER_MIXER.get(), SuperMixerScreen::new);
            event.register((MenuType)BLUEPRINT_BOOK.get(), BlueprintBookContainerScreen::new);
        }
    }
}

