/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.client.Textures;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractCompoundFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.FTBFilterSystemClient;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.SelectionPanel;
import dev.ftb.mods.ftbfiltersystem.network.SyncFilterMessage;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import org.jetbrains.annotations.Nullable;

public class FilterScreen
extends AbstractFilterScreen {
    private static SelectionPanel selectionPanel = null;
    private final SmartFilter filter;
    private final String origFilterStr;
    private final InteractionHand interactionHand;
    private int leftPos;
    private int topPos;
    private int guiWidth;
    private int guiHeight;
    private FilterList filterList;
    private Button addFilterBtn;
    private Button deleteFilterBtn;
    private Button configFilterBtn;
    private Button titleEditBtn;
    private EditBox titleEditBox;
    private SmartFilter newSelection = null;
    private Component newTitle = null;
    private boolean showingTitleEdit = false;

    public FilterScreen(Component component, SmartFilter filter, InteractionHand interactionHand) {
        super(component);
        this.interactionHand = interactionHand;
        selectionPanel = null;
        this.filter = filter;
        this.origFilterStr = filter.asString(FTBFilterSystemClient.registryAccess());
    }

    protected void init() {
        super.init();
        this.setupGuiDimensions();
        this.getSelectionPanel().visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.filterList = new FilterList(this.minecraft, this.topPos + 20, this.getListWidth(), this.getListHeight());
        this.filterList.setX(this.leftPos + 8);
        this.addWidget((GuiEventListener)this.filterList);
        this.titleEditBtn = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos, this.topPos + 3, 16, 16, new WidgetSprites(Textures.EDIT_BUTTON, Textures.EDIT_BUTTON_HI), b -> {
            this.showingTitleEdit = true;
        }));
        int n = this.getListWidth();
        Objects.requireNonNull(this.font);
        this.titleEditBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 5, this.topPos + 4, n, 9 + 4, (Component)Component.empty()));
        this.titleEditBox.visible = false;
        this.titleEditBox.setValue(this.title.getString());
        int buttonWidth = this.guiWidth - this.getListWidth() - 25;
        LinearLayout buttonPanel = new LinearLayout(this.leftPos + this.getListWidth() + 15, this.topPos + 20, LinearLayout.Orientation.VERTICAL).spacing(2);
        this.addFilterBtn = (Button)buttonPanel.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"ftbfiltersystem.gui.add"), b -> this.getSelectionPanel().setVisible(true)).width(buttonWidth).build());
        this.deleteFilterBtn = (Button)buttonPanel.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"ftbfiltersystem.gui.delete"), b -> this.deleteSelectedFilter(true)).width(buttonWidth).build());
        this.configFilterBtn = (Button)buttonPanel.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"ftbfiltersystem.gui.configure"), b -> this.configureSelectedFilter(false)).width(buttonWidth).build());
        buttonPanel.arrangeElements();
        buttonPanel.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        LinearLayout bottomPanel = new LinearLayout(this.leftPos, this.topPos + this.guiHeight - 25, LinearLayout.Orientation.HORIZONTAL);
        ((FrameLayout)bottomPanel.addChild((LayoutElement)new FrameLayout(this.guiWidth / 2, 20))).addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, b -> this.applyChanges()).size(80, 20).build());
        ((FrameLayout)bottomPanel.addChild((LayoutElement)new FrameLayout(this.guiWidth / 2, 20))).addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.closeWithConfirmation()).size(80, 20).build());
        bottomPanel.arrangeElements();
        bottomPanel.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        if (this.filterList.getSelected() == null) {
            this.findAndSelect(this.filter);
        } else {
            this.setupButtons();
        }
    }

    private void applyNewTitle() {
        this.newTitle = Component.literal((String)this.titleEditBox.getValue());
        if (this.newTitle.getString().equals(this.title.getString())) {
            this.newTitle = null;
        }
        this.showingTitleEdit = false;
    }

    private SelectionPanel getSelectionPanel() {
        if (selectionPanel == null) {
            selectionPanel = new SelectionPanel(this.font, this::createNewFilter, this.height - (this.topPos + 20) - 5);
        }
        return selectionPanel;
    }

    private void setupButtons() {
        FilterList.FilterEntry selected = (FilterList.FilterEntry)this.filterList.getSelected();
        this.addFilterBtn.active = selected != null && this.canAddMoreFilters(selected.dumpedFilter.filter());
        this.deleteFilterBtn.active = selected != null && selected.dumpedFilter.filter().getParent() != null;
        this.configFilterBtn.active = selected != null && selected.dumpedFilter.filter().isConfigurable();
    }

    private boolean canAddMoreFilters(SmartFilter filter) {
        SmartFilter.Compound compound;
        if (filter instanceof AbstractCompoundFilter) {
            AbstractCompoundFilter acf = (AbstractCompoundFilter)filter;
            compound = acf;
        } else {
            compound = filter.getParent();
        }
        SmartFilter.Compound parent = compound;
        return parent != null && parent.getChildren().size() < parent.maxChildren();
    }

    private void applyChanges() {
        NetworkManager.sendToServer((CustomPacketPayload)new SyncFilterMessage(this.filter.asString(FTBFilterSystemClient.registryAccess()), this.newTitle == null ? Optional.empty() : Optional.of(this.newTitle.getString()), this.interactionHand));
        this.onClose();
        if (this.changesHaveBeenMade()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"ftbfiltersystem.message.changes_saved").withStyle(ChatFormatting.GREEN), true);
        }
    }

    private boolean changesHaveBeenMade() {
        return !this.filter.asString(FTBFilterSystemClient.registryAccess()).equals(this.origFilterStr) || this.newTitle != null;
    }

    private void createNewFilter(ResourceLocation filterId) {
        this.getSelectionPanel().setVisible(false);
        if (this.filterList.getSelected() != null) {
            SmartFilter.Compound parent;
            SmartFilter selectedFilter = ((FilterList.FilterEntry)this.filterList.getSelected()).dumpedFilter.filter();
            if (selectedFilter instanceof AbstractCompoundFilter) {
                AbstractCompoundFilter acf = (AbstractCompoundFilter)selectedFilter;
                v0 = acf;
            } else {
                v0 = parent = selectedFilter.getParent();
            }
            if (parent != null) {
                FTBFilterSystemAPI.api().createDefaultFilter(parent, filterId).ifPresent(newFilter -> {
                    parent.getChildren().add((SmartFilter)newFilter);
                    this.filterList.addChildren();
                    this.filterList.findAndSelect((SmartFilter)newFilter);
                    this.configureSelectedFilter(true);
                });
            }
        }
    }

    @Override
    public void deleteSelectedFilter(boolean rebuildList) {
        SmartFilter subFilter;
        SmartFilter.Compound parent;
        if (this.filterList.getSelected() != null && (parent = (subFilter = ((FilterList.FilterEntry)this.filterList.getSelected()).dumpedFilter.filter()).getParent()) instanceof SmartFilter.Compound) {
            SmartFilter.Compound compound = parent;
            List<SmartFilter> l = compound.getChildren().stream().filter(f -> f != subFilter).toList();
            compound.getChildren().clear();
            compound.getChildren().addAll(l);
            if (rebuildList) {
                this.filterList.addChildren();
                this.filterList.findAndSelect(parent);
            }
        }
    }

    private void configureSelectedFilter(boolean deleteOnCancel) {
        FilterList.FilterEntry selected = (FilterList.FilterEntry)this.filterList.getSelected();
        if (selected != null) {
            FTBFilterSystemClient.INSTANCE.openFilterConfigScreen(selected.dumpedFilter.filter(), this, deleteOnCancel);
        }
    }

    @Override
    public <T extends SmartFilter> void replaceFilter(T filter, T newFilter) {
        List<SmartFilter> children;
        int idx;
        if (filter.getParent() != null && (idx = (children = filter.getParent().getChildren()).indexOf(filter)) >= 0) {
            children.set(idx, newFilter);
            this.newSelection = newFilter;
        }
    }

    public void tick() {
        if (!(this.minecraft.player.getItemInHand(this.interactionHand).getItem() instanceof SmartFilterItem)) {
            this.onClose();
        } else if (this.showingTitleEdit && !this.titleEditBox.isVisible()) {
            this.titleEditBox.visible = true;
            this.titleEditBtn.visible = false;
            if (Screen.hasShiftDown()) {
                this.titleEditBox.moveCursorToEnd(false);
                this.titleEditBox.setHighlightPos(0);
            }
            this.setFocused((GuiEventListener)this.titleEditBox);
        } else if (!this.showingTitleEdit && this.titleEditBox.isVisible()) {
            this.titleEditBox.visible = false;
            this.titleEditBtn.visible = true;
            this.setFocused((GuiEventListener)this.filterList);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.guiHeight > 0) {
            GuiUtil.drawPanel(guiGraphics, new Rect2i(this.leftPos + 7, this.topPos + 19, this.getListWidth() + 2, this.getListHeight() + 1), -6250336, -6250336, GuiUtil.BorderStyle.INSET, 1);
            this.filterList.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            Component displayTitle = this.newTitle == null ? this.title : this.newTitle;
            guiGraphics.drawString(this.font, displayTitle, this.leftPos + 8, this.topPos + 7, 0x404040, false);
            this.titleEditBtn.setX(this.leftPos + this.font.width((FormattedText)displayTitle) + 8);
        }
        if (this.getSelectionPanel().isVisible()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.guiWidth, this.topPos + this.guiHeight, -1608507360);
            this.getSelectionPanel().positionAndRender(guiGraphics, this.addFilterBtn.getY(), this.addFilterBtn.getX() - 10, mouseX, mouseY, partialTick);
            guiGraphics.pose().popPose();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blitSprite(Textures.BACKGROUND, this.leftPos, this.topPos, this.guiWidth, this.guiHeight);
    }

    public void onClose() {
        this.getSelectionPanel().setVisible(false);
        super.onClose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256 || this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            if (this.getSelectionPanel().isVisible()) {
                this.getSelectionPanel().setVisible(false);
                return true;
            }
            if (this.titleEditBox.canConsumeInput()) {
                if (keyCode == 256) {
                    this.titleEditBox.setValue(this.newTitle == null ? this.title.getString() : this.newTitle.getString());
                    this.showingTitleEdit = false;
                } else {
                    this.titleEditBox.keyPressed(keyCode, scanCode, modifier);
                }
                return true;
            }
            this.closeWithConfirmation();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.titleEditBox.canConsumeInput()) {
                this.applyNewTitle();
                return true;
            }
            if (Screen.hasShiftDown()) {
                this.applyChanges();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifier);
    }

    private void closeWithConfirmation() {
        if (this.changesHaveBeenMade()) {
            this.newSelection = this.filterList.getSelectedFilter();
            this.minecraft.setScreen((Screen)new ConfirmScreen(this::exitCallback, (Component)Component.translatable((String)"ftbfiltersystem.gui.changes_made"), (Component)Component.translatable((String)"ftbfiltersystem.gui.changes_made.question")));
        } else {
            this.onClose();
        }
    }

    private void exitCallback(boolean confirmed) {
        if (confirmed) {
            this.onClose();
        } else {
            this.minecraft.setScreen((Screen)this);
            this.findAndSelect(this.newSelection);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.getSelectionPanel().isVisible() && !this.getSelectionPanel().isMouseOver(mouseX, mouseY)) {
            this.getSelectionPanel().setVisible(false);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private int getListWidth() {
        return this.guiWidth - 100;
    }

    private int getListHeight() {
        return this.guiHeight - 50;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.width = width;
        this.height = height;
        this.setupGuiDimensions();
        SmartFilter selected = this.filterList.getSelected() == null ? null : ((FilterList.FilterEntry)this.filterList.getSelected()).dumpedFilter.filter();
        this.repositionElements();
        this.getSelectionPanel().resize(height - (this.topPos + 20) - 5);
        this.findAndSelect(selected);
    }

    private void setupGuiDimensions() {
        this.guiWidth = this.width * 2 / 3;
        this.guiHeight = this.height * 3 / 4;
        this.leftPos = (this.width - this.guiWidth) / 2;
        this.topPos = (this.height - this.guiHeight) / 2;
    }

    @Override
    public void findAndSelect(@Nullable SmartFilter filter) {
        if (filter != null) {
            this.filterList.findAndSelect(filter);
        }
    }

    private class FilterList
    extends ObjectSelectionList<FilterEntry> {
        private static final int ELEMENT_HEIGHT = 12;
        private FilterEntry dragging;
        private SmartFilter.Compound dragTarget;

        public FilterList(Minecraft minecraft, int y, int width, int height) {
            super(minecraft, width, height, y, 12);
            this.dragging = null;
            this.dragTarget = null;
            this.addChildren();
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        private void addChildren() {
            ArrayList entries = new ArrayList();
            List<DumpedFilter> dumped = FTBFilterSystemAPI.api().dump(FilterScreen.this.filter);
            dumped.forEach(entry -> entries.add(new FilterEntry((DumpedFilter)entry)));
            this.children().clear();
            this.children().addAll(entries);
            if (FilterScreen.this.newSelection != null) {
                this.findAndSelect(FilterScreen.this.newSelection);
                FilterScreen.this.newSelection = null;
            }
        }

        private SmartFilter getSelectedFilter() {
            return this.getSelected() == null ? null : ((FilterEntry)this.getSelected()).dumpedFilter.filter();
        }

        public int getRowWidth() {
            return FilterScreen.this.getListWidth();
        }

        protected int getScrollbarPosition() {
            return FilterScreen.this.leftPos + this.width + 8;
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void setSelected(@Nullable FilterEntry entry) {
            super.setSelected((AbstractSelectionList.Entry)entry);
            FilterScreen.this.setupButtons();
        }

        public boolean mouseReleased(double mouseX, double mouseY, int btn) {
            if (this.dragging != null && this.dragTarget != null) {
                FilterParser.parseFilterList(this.dragTarget, this.dragging.dumpedFilter.filter().asString(FTBFilterSystemClient.registryAccess()), FTBFilterSystemClient.registryAccess()).stream().findFirst().ifPresent(newFilter -> {
                    this.dragTarget.getChildren().add((SmartFilter)newFilter);
                    FilterScreen.this.deleteSelectedFilter(false);
                    this.addChildren();
                    this.findAndSelect((SmartFilter)newFilter);
                });
            }
            this.dragging = null;
            this.dragTarget = null;
            return super.mouseReleased(mouseX, mouseY, btn);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
            SmartFilter smartFilter;
            if (this.dragging == null) return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
            FilterEntry entry = (FilterEntry)this.getEntryAtPosition(pMouseX, pMouseY);
            if (entry != null && (smartFilter = entry.dumpedFilter.filter()) instanceof SmartFilter.Compound) {
                SmartFilter.Compound compound = (SmartFilter.Compound)smartFilter;
                if (!(this.dragging.dumpedFilter.filter() instanceof SmartFilter.Compound && entry.dumpedFilter.indent() > this.dragging.dumpedFilter.indent() || compound == this.dragging.dumpedFilter.filter() || compound == this.dragging.dumpedFilter.filter().getParent() || compound.getChildren().size() >= compound.maxChildren())) {
                    this.dragTarget = compound;
                    return true;
                }
            }
            this.dragTarget = null;
            return true;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 32 || keyCode == 257) {
                FilterScreen.this.configureSelectedFilter(false);
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        protected void renderDecorations(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
            FilterEntry entry;
            if (this.dragging != null && (entry = (FilterEntry)this.getEntryAtPosition(pMouseX, pMouseY)) != null && entry.dumpedFilter.filter() != this.dragging.dumpedFilter.filter()) {
                int w = FilterScreen.this.font.width((FormattedText)this.dragging.dumpedFilter.filter().getDisplayName());
                guiGraphics.fill(pMouseX, pMouseY - 6 + 1, pMouseX + w + 10, pMouseY + 6, -1058934275);
                guiGraphics.renderOutline(pMouseX, pMouseY - 6 + 1, w + 10, 12, -1069531072);
                guiGraphics.drawString(FilterScreen.this.font, this.dragging.dumpedFilter.filter().getDisplayName(), pMouseX + 5, pMouseY - 6 + 3, -1069531072, false);
            }
        }

        protected void renderSelection(GuiGraphics guiGraphics, int pTop, int pWidth, int pHeight, int pOuterColor, int pInnerColor) {
            int minX = this.getX() + (this.width - pWidth) / 2;
            int maxX = this.getX() + (this.width + pWidth) / 2;
            int col = this.isFocused() ? -1969667 : -5851964;
            GuiUtil.drawPanel(guiGraphics, new Rect2i(minX + 1, pTop - 2, maxX - minX - 2, pHeight + 3), col, -12164180, GuiUtil.BorderStyle.PLAIN, 1);
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        private void findAndSelect(SmartFilter filter) {
            this.children().stream().filter(entry -> entry.dumpedFilter.filter() == filter).findFirst().ifPresent(this::setSelected);
        }

        private class FilterEntry
        extends ObjectSelectionList.Entry<FilterEntry> {
            private final DumpedFilter dumpedFilter;
            private long lastClickTime;

            public FilterEntry(DumpedFilter dumpedFilter) {
                this.dumpedFilter = dumpedFilter;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                int labelLeft = left + this.dumpedFilter.indent() * 10;
                int yBase = top + height / 2;
                if (this.dumpedFilter.filter() == FilterList.this.dragTarget && FilterList.this.dragging.dumpedFilter.filter() != FilterList.this.dragTarget) {
                    int n = labelLeft + FilterScreen.this.font.width((FormattedText)this.getLabel()) + 2;
                    Objects.requireNonNull(FilterScreen.this.font);
                    guiGraphics.fill(labelLeft - 2, top - 3, n, top + 9, -3479106);
                    int n2 = FilterScreen.this.font.width((FormattedText)this.getLabel()) + 4;
                    Objects.requireNonNull(FilterScreen.this.font);
                    guiGraphics.renderOutline(labelLeft - 2, top - 3, n2, 9 + 4, -13604796);
                }
                guiGraphics.drawString(FilterScreen.this.font, this.getLabel(), labelLeft, top, 0x404040, false);
                if (index > 0) {
                    guiGraphics.hLine(labelLeft - 8, labelLeft - 2, yBase, -11513728);
                    int yOff = this.calcYoffset(index);
                    guiGraphics.vLine(labelLeft - 8, yBase, yBase - yOff, -11513728);
                }
            }

            private int calcYoffset(int index) {
                int res = 0;
                for (int i = index - 1; i >= 0; --i) {
                    res += FilterList.this.itemHeight;
                    if (((FilterEntry)((Object)FilterList.this.children().get((int)i))).dumpedFilter.indent() < this.dumpedFilter.indent()) break;
                }
                return res - 4;
            }

            public boolean mouseClicked(double x, double y, int button) {
                FilterList.this.setSelected(this);
                if (this.dumpedFilter.filter().getParent() != null) {
                    FilterList.this.dragging = this;
                }
                if (Util.getMillis() - this.lastClickTime < 250L) {
                    FilterScreen.this.configureSelectedFilter(false);
                } else {
                    this.lastClickTime = Util.getMillis();
                }
                return true;
            }

            private Component getLabel() {
                Component disp = this.dumpedFilter.filter().getDisplayName();
                if (this.dumpedFilter.filter() instanceof SmartFilter.Compound) {
                    return disp;
                }
                Component text = this.dumpedFilter.filter().getDisplayArg((HolderLookup.Provider)((FilterList)FilterList.this).minecraft.level.registryAccess());
                return disp.copy().append(" ").append((Component)text.copy().withStyle(ChatFormatting.DARK_BLUE));
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.getLabel()});
            }
        }
    }
}

