/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllDataComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ClipboardEntry {
    public static final Codec<ClipboardEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("checked").forGetter(c -> c.checked), (App)ComponentSerialization.CODEC.fieldOf("text").forGetter(c -> c.text), (App)ItemStack.OPTIONAL_CODEC.fieldOf("icon").forGetter(c -> c.icon), (App)Codec.INT.fieldOf("item_amount").forGetter(c -> c.itemAmount)).apply((Applicative)i, (checked, text, icon, itemAmount) -> {
        ClipboardEntry entry = new ClipboardEntry((boolean)checked, text.copy());
        if (!icon.isEmpty()) {
            entry.displayItem((ItemStack)icon, (int)itemAmount);
        }
        return entry;
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClipboardEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, c -> c.checked, (StreamCodec)ComponentSerialization.STREAM_CODEC, c -> c.text, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, c -> c.icon, (StreamCodec)ByteBufCodecs.INT, c -> c.itemAmount, (checked, text, icon, itemAmount) -> {
        ClipboardEntry entry = new ClipboardEntry((boolean)checked, text.copy());
        if (!icon.isEmpty()) {
            entry.displayItem((ItemStack)icon, (int)itemAmount);
        }
        return entry;
    });
    public boolean checked;
    public MutableComponent text;
    public ItemStack icon;
    public int itemAmount;

    public ClipboardEntry(boolean checked, MutableComponent text) {
        this.checked = checked;
        this.text = text;
        this.icon = ItemStack.EMPTY;
    }

    public ClipboardEntry displayItem(ItemStack icon, int amount) {
        this.icon = icon;
        this.itemAmount = amount;
        return this;
    }

    public static List<List<ClipboardEntry>> readAll(ItemStack clipboardItem) {
        ArrayList<List<ClipboardEntry>> entries = new ArrayList<List<ClipboardEntry>>();
        List saved = (List)clipboardItem.getOrDefault(AllDataComponents.CLIPBOARD_PAGES, Collections.emptyList());
        for (List inner : saved) {
            entries.add(new ArrayList(inner));
        }
        return entries;
    }

    public static List<ClipboardEntry> getLastViewedEntries(ItemStack heldItem) {
        List<List<ClipboardEntry>> pages = ClipboardEntry.readAll(heldItem);
        if (pages.isEmpty()) {
            return new ArrayList<ClipboardEntry>();
        }
        int page = !heldItem.has(AllDataComponents.CLIPBOARD_PREVIOUSLY_OPENED_PAGE) ? 0 : Math.min((Integer)heldItem.getOrDefault(AllDataComponents.CLIPBOARD_PREVIOUSLY_OPENED_PAGE, (Object)0), pages.size() - 1);
        List<ClipboardEntry> entries = pages.get(page);
        return entries;
    }

    public static void saveAll(List<List<ClipboardEntry>> entries, ItemStack clipboardItem) {
        clipboardItem.set(AllDataComponents.CLIPBOARD_PAGES, entries);
    }

    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("Checked", this.checked);
        nbt.putString("Text", Component.Serializer.toJson((Component)this.text, (HolderLookup.Provider)RegistryAccess.EMPTY));
        if (this.icon.isEmpty()) {
            return nbt;
        }
        nbt.put("Icon", this.icon.saveOptional((HolderLookup.Provider)RegistryAccess.EMPTY));
        nbt.putInt("ItemAmount", this.itemAmount);
        return nbt;
    }

    public static ClipboardEntry readNBT(CompoundTag tag) {
        ClipboardEntry clipboardEntry = new ClipboardEntry(tag.getBoolean("Checked"), Component.Serializer.fromJson((String)tag.getString("Text"), (HolderLookup.Provider)RegistryAccess.EMPTY));
        if (tag.contains("Icon")) {
            clipboardEntry.displayItem(ItemStack.parseOptional((HolderLookup.Provider)RegistryAccess.EMPTY, (CompoundTag)tag.getCompound("Icon")), tag.getInt("ItemAmount"));
        }
        return clipboardEntry;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClipboardEntry)) {
            return false;
        }
        ClipboardEntry that = (ClipboardEntry)o;
        return this.checked == that.checked && this.text.equals((Object)that.text) && ItemStack.isSameItemSameComponents((ItemStack)this.icon, (ItemStack)that.icon);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.checked);
        result = 31 * result + this.text.hashCode();
        result = 31 * result + this.icon.hashCode();
        return result;
    }
}

