/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog;

import com.hidoni.transmog.Constants;
import com.hidoni.transmog.RenderUtils;
import com.hidoni.transmog.component.TransmogAppearanceItem;
import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.registry.ModDataComponents;
import com.hidoni.transmog.registry.ModItems;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TransmogUtils {
    private static boolean notInPvP = true;
    private static Thread pvpTimerThread = null;

    public static void startPvP() {
        if (Config.pvpDisableDuration > 0) {
            TransmogUtils.setNotInPvP(false);
            if (pvpTimerThread != null) {
                Constants.LOG.info("Client player still involved in PvP, Extending transmog disable for another {} seconds", (Object)Config.pvpDisableDuration);
                Constants.LOG.debug("Interrupting existing PvP timer thread: {}", (Object)pvpTimerThread);
                pvpTimerThread.interrupt();
            } else {
                Constants.LOG.info("Client player involved in PvP, Disabling transmogs for {} seconds", (Object)Config.pvpDisableDuration);
            }
            pvpTimerThread = new Thread(() -> {
                try {
                    TimeUnit.SECONDS.sleep(Config.pvpDisableDuration);
                    TransmogUtils.setNotInPvP(true);
                    Constants.LOG.info("PvP Timer finished, Transmog re-enabled.");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            pvpTimerThread.start();
            Constants.LOG.debug("Created new PvP timer thread: {}", (Object)pvpTimerThread);
        }
    }

    private static synchronized void setNotInPvP(boolean notInPvP) {
        TransmogUtils.notInPvP = notInPvP;
    }

    public static boolean isItemStackTransmogged(ItemStack itemStack) {
        return itemStack.has((DataComponentType)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get());
    }

    public static boolean isHiddenItem(ItemStack appearanceItem) {
        return appearanceItem.is((Item)ModItems.VOID_FRAGMENT.get());
    }

    public static void transmogAppearanceOntoItemStack(ItemStack appearanceItem, ItemStack itemToTransmog) {
        itemToTransmog.set((DataComponentType)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get(), (Object)new TransmogAppearanceItem(appearanceItem));
    }

    public static ItemStack getAppearanceItemStack(ItemStack itemStack, boolean keepHiddenItem) {
        if (!itemStack.has((DataComponentType)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get())) {
            return itemStack;
        }
        TransmogAppearanceItem appearanceItem = (TransmogAppearanceItem)itemStack.get((DataComponentType)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get());
        if (appearanceItem == null) {
            return itemStack;
        }
        if (!keepHiddenItem && TransmogUtils.isHiddenItem(appearanceItem.itemStack())) {
            return ItemStack.EMPTY;
        }
        return appearanceItem.itemStack();
    }

    public static ItemStack getAppearanceStackOrOriginal(ItemStack itemStack) {
        if (notInPvP && Config.renderOption.renderInWorld && TransmogUtils.isItemStackTransmogged(itemStack)) {
            if (!RenderUtils.isCalledForInventory()) {
                return TransmogUtils.getAppearanceItemStack(itemStack, false);
            }
            if (Config.renderOption.renderInInventory) {
                ItemStack appearanceItemStack = TransmogUtils.getAppearanceItemStack(itemStack, true);
                if (TransmogUtils.isHiddenItem(appearanceItemStack)) {
                    return itemStack;
                }
                appearanceItemStack.setCount(itemStack.getCount());
                return appearanceItemStack;
            }
        }
        return itemStack;
    }
}

