/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.gui;

import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.config.TooltipDetailLevel;
import com.hidoni.transmog.config.TransmogRenderOption;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends OptionsSubScreen {
    public ConfigScreen(Screen parentScreen) {
        super(parentScreen, Minecraft.getInstance().options, (Component)Component.translatable((String)"transmog.config_title"));
    }

    protected void addFooter() {
        LinearLayout linearLayout = ((LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal())).spacing(8);
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            Config.loadConfigFromFile();
            Objects.requireNonNull(this.minecraft).setScreen(this.lastScreen);
        }).width(200).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> Objects.requireNonNull(this.minecraft).setScreen(this.lastScreen)).width(200).build());
    }

    protected void addOptions() {
        if (this.list != null) {
            this.list.addBig(new OptionInstance("transmog.config.render", option -> Tooltip.create((Component)Component.translatable((String)option.getTooltipKey())), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(TransmogRenderOption.values()), Codec.INT.xmap(TransmogRenderOption::fromId, TransmogRenderOption::getId)), (Object)Config.renderOption, option -> {
                Config.renderOption = option;
            }));
            this.list.addBig(new OptionInstance("transmog.config.tooltip", option -> Tooltip.create((Component)Component.translatable((String)option.getTooltipKey())), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(TooltipDetailLevel.values()), Codec.INT.xmap(TooltipDetailLevel::fromId, TooltipDetailLevel::getId)), (Object)Config.tooltipDetailLevel, option -> {
                Config.tooltipDetailLevel = option;
            }));
            this.list.addBig(new OptionInstance("transmog.config.disable_during_pvp_duration", OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)"transmog.config.disable_during_pvp_duration.tooltip")), (component, integer) -> Component.translatable((String)"options.generic_value", (Object[])new Object[]{component, integer == 0 ? Component.translatable((String)"transmog.config.render.off") : Component.translatable((String)"transmog.config.disable_during_pvp_duration.label", (Object[])new Object[]{integer})}), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 120), (Object)Config.pvpDisableDuration, integer -> {
                Config.pvpDisableDuration = integer;
            }));
        }
    }

    public void removed() {
    }

    public void onClose() {
        if (this.list != null) {
            Config.writeConfigToFile();
        }
        Objects.requireNonNull(this.minecraft).setScreen(this.lastScreen);
    }
}

