/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.mixin;

import com.hidoni.transmog.TransmogUtils;
import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.config.TooltipDetailLevel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Unique
    private static final String[] TRANSLATION_KEYS_TO_REMOVE = new String[]{"item.modifiers.*", "attribute.modifier.*", "item.unbreakable", "item.canBreak", "item.canPlace", "item.durability", "item.nbt_tags", "item.disabled", "item.components"};

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void addTransmogTooltipToItemStack(Item.TooltipContext tooltipContext, Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> cir) {
        ItemStack thisStack = (ItemStack)this;
        if (Config.tooltipDetailLevel == TooltipDetailLevel.NONE || thisStack.has(DataComponents.HIDE_TOOLTIP) || thisStack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return;
        }
        if (TransmogUtils.isItemStackTransmogged(thisStack)) {
            ItemStack appearanceStack = TransmogUtils.getAppearanceItemStack(thisStack, true);
            List originalItemLines = (List)cir.getReturnValue();
            originalItemLines.add(Component.translatable((String)"transmog.transmog_description").withStyle(ChatFormatting.LIGHT_PURPLE));
            originalItemLines.addAll(ItemStackMixin.getTransmogTooltipLines(tooltipContext, player, tooltipFlag, appearanceStack));
        }
    }

    @Unique
    @NotNull
    private static List<Component> getTransmogTooltipLines(Item.TooltipContext tooltipContext, Player player, TooltipFlag tooltipFlag, ItemStack appearanceStack) {
        List<MutableComponent> components;
        if (TransmogUtils.isHiddenItem(appearanceStack)) {
            components = List.of(Component.translatable((String)"transmog.transmog_hidden").withStyle(ChatFormatting.LIGHT_PURPLE));
        } else if (Config.tooltipDetailLevel == TooltipDetailLevel.MINIMAL) {
            components = new ArrayList<MutableComponent>(List.of(Component.empty().append(appearanceStack.getItem().getName(appearanceStack)).withStyle(appearanceStack.getRarity().color())));
            if (tooltipFlag.isAdvanced()) {
                components.add(Component.literal((String)BuiltInRegistries.ITEM.getKey((Object)appearanceStack.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
        } else {
            components = new ArrayList<Component>(appearanceStack.getTooltipLines(tooltipContext, player, tooltipFlag).stream().filter(ItemStackMixin::keepComponent).toList());
            if (((Component)components.getLast()).equals((Object)CommonComponents.EMPTY)) {
                components.removeLast();
            }
        }
        return components;
    }

    @Unique
    private static boolean keepComponent(Component component) {
        if (!(component instanceof MutableComponent)) {
            return true;
        }
        MutableComponent mutableComponent = (MutableComponent)component;
        String[] stringArray = mutableComponent.getContents();
        if (stringArray instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)stringArray;
            for (String translationKey : TRANSLATION_KEYS_TO_REMOVE) {
                if (translationKey.endsWith("*") && translatableContents.getKey().startsWith(translationKey.replace("*", ""))) {
                    return false;
                }
                if (!translatableContents.getKey().equals(translationKey)) continue;
                return false;
            }
        }
        for (Component sibling : mutableComponent.getSiblings()) {
            if (ItemStackMixin.keepComponent(sibling)) continue;
            return false;
        }
        return true;
    }
}

