/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.logic;

import appeng.hooks.ticking.TickHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;

public class ThroughputCache {
    private final int MAX_SIZE = AAEConfig.instance().getThroughputMonitorCacheSize();
    private final LinkedList<CacheEntry> cache = new LinkedList();

    public int size() {
        return this.cache.size();
    }

    public void push(long amount, long timestamp) {
        if (timestamp == 0L) {
            return;
        }
        if (!this.cache.isEmpty() && this.cache.getFirst().timestamp == timestamp) {
            return;
        }
        this.cache.addFirst(new CacheEntry(amount, timestamp));
        if (this.cache.size() > this.MAX_SIZE) {
            this.cache.removeLast();
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public double averagePerTick(int timeLimit_s) {
        long now = TickHandler.instance().getCurrentTick();
        long tLimit = now - (long)timeLimit_s * 20L;
        long lastAmount = -1L;
        long lastTimestamp = -1L;
        ArrayList<Double> averages = new ArrayList<Double>();
        for (CacheEntry entry : this.cache) {
            if (entry.timestamp < tLimit) break;
            if (lastTimestamp != -1L) {
                long timestampDelta = lastTimestamp - entry.timestamp;
                long amountDelta = lastAmount - entry.amount;
                averages.add((double)amountDelta / (double)timestampDelta);
            }
            lastAmount = entry.amount;
            lastTimestamp = entry.timestamp;
        }
        double average = 0.0;
        int size = averages.size();
        for (Double avg : averages) {
            average += avg / (double)size;
        }
        return average;
    }

    private record CacheEntry(long amount, long timestamp) {
    }
}

