/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.parts;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.DefaultPriorityList;
import appeng.util.prioritylist.IPartitionList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.helpers.StorageReader;
import net.pedroksl.advanced_ae.common.helpers.StorageReaderImpl;
import net.pedroksl.advanced_ae.common.parts.StackTransferContextImpl;
import net.pedroksl.advanced_ae.mixins.MixinIOBusPartInvoker;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.appmek.AppMekPlugin;
import org.jetbrains.annotations.NotNull;

public class StockExportBusPart
extends ExportBusPart
implements ISubMenuHost {
    public static final ResourceLocation MODEL_BASE = AdvancedAE.makeId("part/stock_export_bus_part");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_has_channel")});
    private ConfigInventory config;
    private ArrayList<StorageReader> storageReaders;

    public StockExportBusPart(IPartItem<?> partItem) {
        super(partItem);
    }

    protected int getUpgradeSlots() {
        return 6;
    }

    public void readFromNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.readFromNBT(extra, registries);
        this.config.readFromChildTag(extra, "extraConfig", registries);
    }

    public void writeToNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.writeToNBT(extra, registries);
        this.config.writeToChildTag(extra, "extraConfig", registries);
    }

    public ConfigInventory getConfig() {
        if (this.config == null) {
            this.config = ConfigInventory.configStacks((int)63).supportedTypes((Collection)StackWorldBehaviors.withExportStrategy()).changeListener(() -> ((MixinIOBusPartInvoker)((Object)this)).callUpdateState()).allowOverstacking(true).build();
        }
        return this.config;
    }

    private ArrayList<StorageReader> getSimStrategies() {
        BlockEntity self = this.getHost().getBlockEntity();
        BlockPos fromPos = self.getBlockPos().relative(this.getSide());
        Direction fromSide = this.getSide().getOpposite();
        ServerLevel level = (ServerLevel)this.getLevel();
        if (this.storageReaders == null) {
            this.storageReaders = new ArrayList();
            this.storageReaders.add(StorageReaderImpl.item(level, fromPos, fromSide));
            this.storageReaders.add(StorageReaderImpl.fluid(level, fromPos, fromSide));
            if (Addons.APPMEK.isLoaded()) {
                this.storageReaders.add(AppMekPlugin.chemicalStorageReader((ServerLevel)this.getLevel(), fromPos, fromSide));
            }
        }
        return this.storageReaders;
    }

    protected boolean doBusWork(IGrid grid) {
        int x;
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        StackTransferContext context = this.createTransferContext(storageService, grid.getEnergyService());
        for (x = 0; x < this.availableSlots() && context.hasOperationsLeft(); ++x) {
            int slotToExport = this.getStartingSlot(schedulingMode, x);
            GenericStack stack = this.getConfig().getStack(slotToExport);
            if (stack == null || stack.what() == null) continue;
            AEKey what = stack.what();
            int amount = (int)stack.amount();
            if (this.craftOnly()) {
                this.attemptCrafting(context, cg, slotToExport, what, amount);
                continue;
            }
            int before = context.getOperationsRemaining();
            int transferFactor = what.getAmountPerOperation();
            long maxAmount = (long)context.getOperationsRemaining() * (long)transferFactor;
            long currentAmount = this.getCurrentStock(what);
            maxAmount = Math.min(maxAmount, (long)amount - currentAmount);
            long transferred = this.getExportStrategy().transfer(context, what, maxAmount);
            if (transferred > 0L) {
                context.reduceOperationsRemaining(Math.max(1L, transferred / (long)transferFactor));
            }
            if (before != context.getOperationsRemaining() || !this.isCraftingEnabled()) continue;
            this.attemptCrafting(context, cg, slotToExport, what, amount);
        }
        if (context.hasDoneWork()) {
            this.updateSchedulingMode(schedulingMode, x);
        }
        return context.hasDoneWork();
    }

    private void attemptCrafting(StackTransferContext context, ICraftingService cg, int slotToExport, AEKey what, long targetAmount) {
        long maxAmount = (long)context.getOperationsRemaining() * (long)what.getAmountPerOperation();
        long currentAmount = this.getCurrentStock(what);
        maxAmount = Math.min(maxAmount, targetAmount - currentAmount);
        long amount = this.getExportStrategy().push(what, maxAmount, Actionable.SIMULATE);
        if (amount > 0L) {
            this.requestCrafting(cg, slotToExport, what, amount);
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)what.getAmountPerOperation()));
        }
    }

    @NotNull
    private StackTransferContext createTransferContext(IStorageService storageService, IEnergyService energyService) {
        return new StackTransferContextImpl(storageService, (IEnergySource)energyService, this.source, this.getOperationsPerTick(), (IPartitionList)DefaultPriorityList.INSTANCE);
    }

    protected long getCurrentStock(AEKey what) {
        ArrayList<StorageReader> strategies = this.getSimStrategies();
        long total = 0L;
        for (StorageReader strategy : strategies) {
            if (!(strategy instanceof StorageReader)) continue;
            StorageReader s = strategy;
            total += s.getCurrentStock(what);
        }
        return total;
    }

    private boolean craftOnly() {
        return this.isCraftingEnabled() && this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.isUpgradedWith((ItemLike)AEItems.CRAFTING_CARD);
    }

    protected MenuType<?> getMenuType() {
        return AAEMenus.STOCK_EXPORT_BUS.get();
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.open(AAEMenus.STOCK_EXPORT_BUS.get(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return this.getPartItem().asItem().getDefaultInstance();
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

