/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipe;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CauldronCraftingContainer
implements RecipeInput {
    private final List<ItemStack> originalItems;
    private final NonNullList<ItemStack> items;
    private final SoftFluidStack fluid;
    private final int fluidContainerSize;
    private final Multimap<FluidContainerList.Category, ItemStack> equivalentFluidContainers;
    private final int dimension;
    private final int fluidPosition;
    private final boolean isBoiling;
    private static final FluidContainerList.Category DUMMY_WATER_BOWL_CATEGORY = (FluidContainerList.Category)Util.make(() -> {
        JsonElement j = JsonParser.parseString((String)("{\n    \"capacity\":" + SoftFluid.BOWL_COUNT + ",        \"empty\": \"minecraft:bowl\",\n        \"filled\": [\n        \"minecraft:mushroom_stew\"\n        ]\n    }\n"));
        return (FluidContainerList.Category)((Pair)FluidContainerList.Category.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)j).getOrThrow()).getFirst();
    });

    private CauldronCraftingContainer(int fluidContainerSize, SoftFluidStack fluidStack, Collection<ItemStack> items, int fluidPosition, boolean isBoiling) {
        this.dimension = Mth.ceil((double)Math.sqrt(items.size() + 1));
        this.originalItems = List.copyOf(items);
        this.items = NonNullList.withSize((int)(this.dimension * this.dimension), (Object)ItemStack.EMPTY);
        this.fluid = fluidStack;
        this.equivalentFluidContainers = fluidStack.toAllPossibleFilledItems();
        if (fluidStack.is(MLBuiltinSoftFluids.WATER)) {
            this.equivalentFluidContainers.put((Object)DUMMY_WATER_BOWL_CATEGORY, (Object)Items.BOWL.getDefaultInstance());
        }
        this.fluidPosition = fluidPosition;
        Preconditions.checkArgument((fluidPosition <= items.size() ? 1 : 0) != 0);
        this.fluidContainerSize = fluidContainerSize;
        this.isBoiling = isBoiling;
    }

    private Collection<ItemStack> splitItems(Collection<ItemStack> items) {
        return null;
    }

    public static CauldronCraftingContainer surround8(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, ItemStack item) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, List.of(item, item, item, item, item, item, item, item), 4, boiling);
    }

    public static CauldronCraftingContainer of(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, Collection<ItemStack> items) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, items, items.size(), boiling);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public ItemStack getItem(int slot) {
        if (slot >= this.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(slot);
    }

    public SoftFluidStack getFluid() {
        return this.fluid;
    }

    public int getMaxAllowedFluidCount() {
        return this.fluidContainerSize;
    }

    protected CraftingInput makeCraftingInput() {
        return CraftingInput.of((int)this.dimension, (int)this.dimension, this.items);
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCauldronRecipes(Level level) {
        for (int j = 0; j < this.originalItems.size(); ++j) {
            this.items.set(j, (Object)this.originalItems.get(j));
        }
        List recipes = level.getRecipeManager().getRecipesFor(ModRegistry.CAULDRON_RECIPE_TYPE.get(), (RecipeInput)this, level);
        for (RecipeHolder h : recipes) {
            CauldronRecipe r = (CauldronRecipe)h.value();
            if (!r.matches(this, level)) continue;
            FluidAndItemCraftResult resultFluid = r.assembleFluid(this, (HolderLookup.Provider)level.registryAccess());
            NonNullList remainingItems = r.getRemainingItems(this);
            if (!remainingItems.stream().allMatch(ItemStack::isEmpty)) continue;
            return resultFluid;
        }
        return null;
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCraftingRecipes(Level level) {
        for (Map.Entry cont : this.equivalentFluidContainers.entries()) {
            FluidContainerList.Category category = (FluidContainerList.Category)cont.getKey();
            ItemStack fluidInBottle = (ItemStack)cont.getValue();
            this.setupFluidItem(fluidInBottle);
            CraftingInput input = this.makeCraftingInput();
            List recipes = level.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)input, level);
            for (RecipeHolder h : recipes) {
                ItemStack craftedItem;
                int newFluidCount;
                CraftingRecipe r = (CraftingRecipe)h.value();
                if (!r.matches((RecipeInput)input, level) || (newFluidCount = this.fluid.getCount() - category.getCapacity()) < 0 || newFluidCount > this.fluidContainerSize || (craftedItem = r.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess())).isEmpty()) continue;
                NonNullList remainingItems = r.getRemainingItems((RecipeInput)input);
                Item emptyContainer = category.getEmptyContainer();
                if (remainingItems.stream().allMatch(ItemStack::isEmpty)) {
                    FluidContainerList.Category catt;
                    if (fluidInBottle.is(Items.LINGERING_POTION)) {
                        return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
                    }
                    Pair equivalentFluid = SoftFluidStack.fromItem((ItemStack)craftedItem, (HolderLookup.Provider)level.registryAccess());
                    if (equivalentFluid == null || (catt = (FluidContainerList.Category)equivalentFluid.getSecond()).getEmptyContainer() != emptyContainer) continue;
                    SoftFluidStack f = (SoftFluidStack)equivalentFluid.getFirst();
                    return FluidAndItemCraftResult.of(ItemStack.EMPTY, f.copyWithCount(this.fluid.getCount()));
                }
                if (!remainingItems.stream().allMatch(i -> i.isEmpty() || i.getItem() == emptyContainer)) continue;
                return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
            }
        }
        return null;
    }

    private void setupFluidItem(ItemStack filledFluidBottle) {
        this.items.clear();
        int j = 0;
        for (ItemStack item : this.originalItems) {
            if (j == this.fluidPosition) {
                ++j;
            }
            this.items.set(j, (Object)item);
            ++j;
        }
        this.items.set(this.fluidPosition, (Object)filledFluidBottle);
    }

    public boolean isBoiling() {
        return this.isBoiling;
    }
}

