/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.integration.jei;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import cy.jdkdigital.sgearmetalworks.integration.jei.JeiPlugin;
import cy.jdkdigital.sgearmetalworks.recipe.SilentGearCastingRecipe;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class SilentGearCastingRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<SilentGearCastingRecipe>> {
    private final IDrawable background;

    public SilentGearCastingRecipeCategory(IGuiHelper guiHelper) {
        super(JeiPlugin.SG_CASTING, (Component)Component.translatable((String)"jei.productivemetalworks.sg_casting"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MetalworksRegistrator.CASTING_TABLE.get())), 200, 100);
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"textures/gui/jei/item_casting.png"), 0, 0, 165, 68).setTextureSize(165, 68).build();
    }

    public void draw(RecipeHolder<SilentGearCastingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<SilentGearCastingRecipe> recipe, IFocusGroup focuses) {
        boolean hasCast;
        ClientLevel level = Minecraft.getInstance().level;
        boolean bl = hasCast = !((SilentGearCastingRecipe)recipe.value()).cast.isEmpty();
        if (hasCast) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 63, 26).addIngredients(((SilentGearCastingRecipe)recipe.value()).cast)).setSlotName("cast");
        }
        Map fluids = FluidHelper.materialsToFluids((Level)level, (Stream)((SilentGearCastingRecipe)recipe.value()).material.getItems(), (int)((SilentGearCastingRecipe)recipe.value()).materialCount);
        List<Fluid> fluidFocuses = focuses.getFocuses((IIngredientType)NeoForgeTypes.FLUID_STACK).map(focus -> (FluidStack)focus.getTypedValue().getIngredient()).map(FluidStack::getFluid).toList();
        List<FluidStack> fluidStacks = fluids.entrySet().stream().filter(entry -> fluidFocuses.isEmpty() || fluidFocuses.contains(entry.getKey())).map(entry -> new FluidStack((Fluid)entry.getKey(), ((Integer)((Pair)entry.getValue()).getSecond()).intValue())).toList();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 26).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStacks)).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll((Collection)FluidHelper.formatTooltip((FluidStack)((FluidStack)fluidStacks.getFirst())))).setFluidRenderer((long)((SilentGearCastingRecipe)recipe.value()).fluid.amount(), false, 16, 16).setSlotName("fluids_tank");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 68, 16).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStacks)).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll((Collection)FluidHelper.formatTooltip((FluidStack)((FluidStack)fluidStacks.getFirst())))).setFluidRenderer((long)((SilentGearCastingRecipe)recipe.value()).fluid.amount(), false, 6, hasCast ? 10 : 26).setSlotName("fluids");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 26).addItemStack(((SilentGearCastingRecipe)recipe.value()).result)).setStandardSlotBackground().setSlotName("result");
    }
}

