/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigMain {
    public static final ModConfigSpec CONFIG_SPEC;
    public static final ConfigMain CONFIG;
    public final ModConfigSpec.BooleanValue allowRemoveCalls;
    public final ModConfigSpec.BooleanValue enableCallBubbling;
    public final FilteredConfigValue removeLookGoal;
    public final FilteredConfigValue removeLookRandom;
    public final FilteredConfigValue replaceLookController;
    public final ModConfigSpec.BooleanValue removeFishSwim;
    public final ModConfigSpec.BooleanValue removeFishAvoidPlayer;
    public final ModConfigSpec.BooleanValue removeFishPanic;
    public final ModConfigSpec.BooleanValue removeFishFollowLeader;
    public final ModConfigSpec.BooleanValue removeFishPuff;
    public final ModConfigSpec.BooleanValue removeSquidFlee;
    public final ModConfigSpec.BooleanValue removeRandomMove;
    public final AnimalConfigSection cow;
    public final AnimalConfigSection chicken;
    public final AnimalConfigSection pig;
    public final AnimalConfigSection sheep;
    public final ModConfigSpec.BooleanValue removeSheepEatBlock;

    ConfigMain(ModConfigSpec.Builder builder) {
        builder.comment("Entity Settings").push("entity");
        builder.comment("General").push("general");
        this.allowRemoveCalls = builder.comment("Allow AI tasks to be removed from entities at runtime. If this is disable no per mob or per mob type removes will run.").define("allow_remove_calls", true);
        this.enableCallBubbling = builder.comment("Allows repeat remove calls to bubble to the top of the list to improve performance of repeat mob spawning.").define("enable_call_bubbling", true);
        builder.pop();
        builder.comment("Entity Mob").push("mob");
        this.removeLookGoal = this.createFilteredConfigValue(builder, "Remove Look Goal", "Remove the look at goal (player or attack target) AI task. This will cause AIs to not face targets or walking directions.", "remove_look_goal", false);
        this.removeLookRandom = this.createFilteredConfigValue(builder, "Remove Look Random", "Remove the look at random position AI task. This will cause AIs to feel a little lifeless as they do not animate head movement while idle.", "remove_look_random", false);
        this.replaceLookController = this.createFilteredConfigValue(builder, "Replace Look Controller", "Replaces the default look controller with a version featuring cached tan math improving performance. Only works on vanilla style mobs, if a mod overrides the look controller it will skip.", "replace_look_controller", true);
        builder.pop();
        builder.comment("Entity Fish").push("fish");
        this.removeFishSwim = builder.comment("Remove the fish's random swimming pathfinder. This will cause fish to stay in position more often.").define("remove_swim", false);
        this.removeFishPanic = builder.comment("Remove the fish's panic pathfinder. This will cause fish to not run away.").define("remove_panic", false);
        this.removeFishAvoidPlayer = builder.comment("Remove the fish's AI task to avoid players.").define("remove_avoid_player", false);
        this.removeFishFollowLeader = builder.comment("Remove the fish's AI task to follow a leader fish to act as a group of fish.").define("remove_follow_leader", false);
        this.removeFishPuff = builder.comment("Remove the fish's AI task to puff up when entities are nearby").define("remove_puff", false);
        builder.pop();
        builder.comment("Squid Fish").push("squid");
        this.removeSquidFlee = builder.comment("Remove the squid's flee pathfinder. This will cause squid to not run away.").define("remove_flee", false);
        this.removeRandomMove = builder.comment("Remove the squid's random movement pathfinder. This will cause squid to swim around randomly.").define("remove_random_move", false);
        builder.pop();
        this.cow = this.createAnimalConfigSection(builder, "Cow", "cow", "cows", true);
        this.chicken = this.createAnimalConfigSection(builder, "Chicken", "chicken", "chickens", true);
        this.pig = this.createAnimalConfigSection(builder, "Pig", "pig", "pigs", true);
        this.sheep = this.createAnimalConfigSection(builder, "Sheep", "sheep", "sheep", false);
        this.removeSheepEatBlock = builder.comment("Remove the sheep's eat block AI task. This causes sheep to no longer eat grass, and thus be unable to regenerate their wool.").define("remove_eat_block", false);
        builder.pop();
        builder.pop();
    }

    private AnimalConfigSection createAnimalConfigSection(ModConfigSpec.Builder builder, String categoryComment, String singular, String plural, boolean shouldPop) {
        builder.comment(categoryComment).push(singular);
        AnimalConfigSection animalConfig = new AnimalConfigSection(builder.comment(String.format("Remove the %s's float AI task. This causes %s to no longer swim in water.", singular, plural)).define("remove_float", false), builder.comment(String.format("Remove the %s's panic AI task. This causes %s to no longer run around after being hit, or search water to extinguish themselves.", singular, plural)).define("remove_panic", false), builder.comment(String.format("Remove the %s's breed AI task. This causes %s to be unable to breed to create offspring.", singular, plural)).define("remove_breed", false), builder.comment(String.format("Remove the %s's tempt AI task. This causes %s to no longer follow the player if they're holding an item they like.", singular, plural)).define("remove_tempt", false), builder.comment(String.format("Remove the %s's follow parent AI task. This causes baby %s to no longer follow their parents.", singular, plural)).define("remove_follow_parent", false), builder.comment(String.format("Remove the %s's random stroll AI task. This causes %s to no longer walk around randomly.", singular, plural)).define("remove_stroll", false));
        if (shouldPop) {
            builder.pop();
        }
        return animalConfig;
    }

    private FilteredConfigValue createFilteredConfigValue(ModConfigSpec.Builder builder, String section, String comment, String path, boolean defaultValue) {
        builder.comment(section).push(path);
        FilteredConfigValue filteredConfigValue = new FilteredConfigValue(builder.comment(comment).define(path, defaultValue), builder.comment("Set this to true to apply this setting to all mobs on the filter list. Set this to false to NOT apply this to mobs on the filter list.").define("is_allowlist", false), (ModConfigSpec.ConfigValue<List<? extends String>>)builder.comment("The list of mobs that is affected by this setting according to is_allowlist").defineList("filter_list", List.of(), e -> e instanceof String));
        builder.pop();
        return filteredConfigValue;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ConfigMain::new);
        CONFIG_SPEC = (ModConfigSpec)specPair.getRight();
        CONFIG = (ConfigMain)specPair.getLeft();
    }

    public record FilteredConfigValue(ModConfigSpec.BooleanValue configValue, ModConfigSpec.BooleanValue isAllowlist, ModConfigSpec.ConfigValue<List<? extends String>> filterList) {
        public boolean isFiltered(String string) {
            return ((Boolean)this.isAllowlist.get()).booleanValue() != ((List)this.filterList.get()).contains(string);
        }
    }

    public record AnimalConfigSection(ModConfigSpec.BooleanValue removeFloat, ModConfigSpec.BooleanValue removePanic, ModConfigSpec.BooleanValue removeBreed, ModConfigSpec.BooleanValue removeTempt, ModConfigSpec.BooleanValue removeFollowParent, ModConfigSpec.BooleanValue removeStroll) {
    }
}

