/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dysoncubeproject.world;

import com.buuz135.dysoncubeproject.world.DysonSphereStructure;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class DysonSphereProgressSavedData
extends SavedData {
    public static final String ID = "dyson_sphere_progress";
    private HashMap<String, DysonSphereStructure> spheres = new HashMap();
    private HashMap<String, String> subscribedPlayers = new HashMap();

    public static DysonSphereProgressSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerLevel serverWorld = serverLevel.getServer().getLevel(Level.OVERWORLD);
            DysonSphereProgressSavedData data = (DysonSphereProgressSavedData)serverWorld.getDataStorage().computeIfAbsent(new SavedData.Factory(DysonSphereProgressSavedData::new, (compoundTag, provider) -> DysonSphereProgressSavedData.load(provider, compoundTag)), ID);
            return data;
        }
        return null;
    }

    public static DysonSphereProgressSavedData load(HolderLookup.Provider provider, CompoundTag compoundTag) {
        DysonSphereProgressSavedData data = new DysonSphereProgressSavedData();
        CompoundTag spheres = compoundTag.getCompound("spheres");
        for (String key : spheres.getAllKeys()) {
            data.spheres.put(key, new DysonSphereStructure());
            data.spheres.get(key).deserializeNBT(provider, spheres.getCompound(key));
        }
        CompoundTag subscribedPlayers = compoundTag.getCompound("subscribedPlayers");
        for (String key : subscribedPlayers.getAllKeys()) {
            data.subscribedPlayers.put(key, subscribedPlayers.getString(key));
        }
        return data;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag spheres = new CompoundTag();
        for (String string : this.spheres.keySet()) {
            spheres.put(string, (Tag)this.spheres.get(string).serializeNBT(provider));
        }
        CompoundTag subscribedPlayers = new CompoundTag();
        for (String key : this.subscribedPlayers.keySet()) {
            subscribedPlayers.putString(key, this.subscribedPlayers.get(key));
        }
        CompoundTag compoundTag2 = new CompoundTag();
        compoundTag2.put("spheres", (Tag)spheres);
        compoundTag2.put("subscribedPlayers", (Tag)subscribedPlayers);
        return compoundTag2;
    }

    public HashMap<String, DysonSphereStructure> getSpheres() {
        return this.spheres;
    }

    public HashMap<String, String> getSubscribedPlayers() {
        return this.subscribedPlayers;
    }

    public String getSubscribedFor(String playerUUID) {
        return this.subscribedPlayers.getOrDefault(playerUUID, playerUUID);
    }
}

