/*
 * Decompiled with CFR 0.152.
 */
package com.Zhu_Yii.zylob.config;

import com.Zhu_Yii.zylob.config.lobConfig;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ModConfigScreen
extends Screen {
    private final Screen parent;
    private ConfigList list;
    private boolean modSwitch;
    private boolean darkRendering;
    private double opacity;
    private double colorEn;
    private double textureLight;
    private boolean extraLightS;
    private double extraLight;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"zylob.ui.title"));
        this.parent = parent;
        this.modSwitch = (Boolean)lobConfig.MOD_SWITCH.get();
        this.darkRendering = (Boolean)lobConfig.DARK_RENDERING.get();
        this.opacity = (Double)lobConfig.OPACITY.get();
        this.colorEn = (Double)lobConfig.COLOR_EN.get();
        this.textureLight = (Double)lobConfig.TEXTURE_LIGHT.get();
        this.extraLightS = (Boolean)lobConfig.EXTRA_LIGHT_S.get();
        this.extraLight = (Double)lobConfig.EXTRA_LIGHT.get();
    }

    protected void init() {
        super.init();
        this.list = new ConfigList(this.minecraft, this.width, this.height, 32, 25);
        this.addWidget((GuiEventListener)this.list);
        this.list.addEntry(new BooleanOptionEntry((Component)Component.translatable((String)"zylob.ui.mod.switch"), () -> this.modSwitch, value -> {
            this.modSwitch = value;
        }));
        this.list.addEntry(new BooleanOptionEntry((Component)Component.translatable((String)"zylob.ui.dark.rendering"), () -> this.darkRendering, value -> {
            this.darkRendering = value;
        }));
        this.list.addEntry(new SliderOptionEntry((Component)Component.translatable((String)"zylob.ui.opacity"), () -> this.opacity, 0.0, 1.0, value -> {
            this.opacity = value;
        }));
        this.list.addEntry(new SliderOptionEntry((Component)Component.translatable((String)"zylob.ui.colorEn"), () -> this.colorEn, 1.0, 2.0, value -> {
            this.colorEn = value;
        }));
        this.list.addEntry(new SliderOptionEntry((Component)Component.translatable((String)"zylob.ui.texture.light"), () -> this.textureLight, 0.0, 255.0, value -> {
            this.textureLight = value;
        }));
        this.list.addEntry(new TitleEntry((Component)Component.translatable((String)"zylob.ui.title.extraLightSettings").withStyle(style -> style.withBold(Boolean.valueOf(true)).withColor(11873581))));
        this.list.addEntry(new BooleanOptionEntry((Component)Component.translatable((String)"zylob.ui.dark.extraLightS"), () -> this.extraLightS, value -> {
            this.extraLightS = value;
        }));
        this.list.addEntry(new SliderOptionEntry((Component)Component.translatable((String)"zylob.ui.texture.extraLight"), () -> this.extraLight, 1.0, 20.0, value -> {
            this.extraLight = value;
        }));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
            lobConfig.MOD_SWITCH.set((Object)this.modSwitch);
            lobConfig.DARK_RENDERING.set((Object)this.darkRendering);
            lobConfig.OPACITY.set((Object)this.opacity);
            lobConfig.COLOR_EN.set((Object)this.colorEn);
            lobConfig.TEXTURE_LIGHT.set((Object)this.textureLight);
            lobConfig.EXTRA_LIGHT_S.set((Object)this.extraLightS);
            lobConfig.EXTRA_LIGHT.set((Object)this.extraLight);
            lobConfig.saveConfig();
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(this.width / 2 - 100, this.height - 27, 200, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        this.list.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    private static class ConfigList
    extends ContainerObjectSelectionList<Entry> {
        public ConfigList(Minecraft minecraft, int width, int height, int top, int itemHeight) {
            super(minecraft, width, height, top, itemHeight);
        }

        public int addEntry(@NotNull Entry entry) {
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        public static abstract class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            public abstract void render(@NotNull GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);
        }
    }

    private static class BooleanOptionEntry
    extends ConfigList.Entry {
        private final Component label;
        private final Button button;

        public BooleanOptionEntry(Component label, BooleanSupplier getter, Consumer<Boolean> setter) {
            this.label = label;
            this.button = Button.builder((Component)Component.translatable((String)(getter.getAsBoolean() ? "options.on" : "options.off")), button -> {
                boolean newValue = !getter.getAsBoolean();
                setter.accept(newValue);
                button.setMessage((Component)Component.translatable((String)(newValue ? "options.on" : "options.off")));
            }).build();
        }

        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            guiGraphics.drawString(Minecraft.getInstance().font, this.label, left, top + (height - 8) / 2, 0xFFFFFF);
            this.button.setX(left + width - 110);
            this.button.setY(top);
            this.button.setWidth(100);
            this.button.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.button);
        }
    }

    private static class SliderOptionEntry
    extends ConfigList.Entry {
        private final Component label;
        private final AbstractSliderButton slider;

        public SliderOptionEntry(Component label, DoubleSupplier getter, final double min, final double max, final Consumer<Double> setter) {
            this.label = label;
            double initialValue = getter.getAsDouble();
            double sliderValue = Math.max(0.0, Math.min(1.0, (initialValue - min) / (max - min)));
            this.slider = new AbstractSliderButton(this, 0, 0, 100, 20, (Component)Component.literal((String)""), sliderValue){

                protected void updateMessage() {
                    double actualValue = this.value * (max - min) + min;
                    this.setMessage((Component)Component.literal((String)String.format("%.2f", actualValue)));
                }

                protected void applyValue() {
                    double result = this.value * (max - min) + min;
                    setter.accept(result);
                }
            };
        }

        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            guiGraphics.drawString(Minecraft.getInstance().font, this.label, left, top + (height - 8) / 2, 0xFFFFFF);
            this.slider.setX(left + width - 110);
            this.slider.setY(top);
            this.slider.setWidth(100);
            this.slider.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.slider);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.slider);
        }
    }

    private static class TitleEntry
    extends ConfigList.Entry {
        private final Component title;

        public TitleEntry(Component title) {
            this.title = title;
        }

        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            int textWidth = Minecraft.getInstance().font.width((FormattedText)this.title);
            int x = left + (width - textWidth) / 2;
            guiGraphics.drawString(Minecraft.getInstance().font, this.title, x, top + (height - 8) / 2, 0xFFFFFF);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of();
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }
    }
}

