/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.api.biome.sub;

import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import com.terraformersmc.biolith.impl.biome.sub.AbstractBiomeCriterion;
import com.terraformersmc.biolith.impl.biome.sub.AllOfCriterion;
import com.terraformersmc.biolith.impl.biome.sub.AlternateCriterion;
import com.terraformersmc.biolith.impl.biome.sub.AnyOfCriterion;
import com.terraformersmc.biolith.impl.biome.sub.DeviationCriterion;
import com.terraformersmc.biolith.impl.biome.sub.NeighborCriterion;
import com.terraformersmc.biolith.impl.biome.sub.NotCriterion;
import com.terraformersmc.biolith.impl.biome.sub.OriginalCriterion;
import com.terraformersmc.biolith.impl.biome.sub.RatioCriterion;
import com.terraformersmc.biolith.impl.biome.sub.ValueCriterion;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class CriterionBuilder {
    public static final Criterion NEAR_BORDER = CriterionBuilder.ratioMax(RatioTargets.EDGE, 0.2f);
    public static final Criterion NEAR_INTERIOR = CriterionBuilder.ratioMax(RatioTargets.CENTER, 0.2f);
    public static final Criterion BEACHSIDE = CriterionBuilder.allOf(NEAR_BORDER, CriterionBuilder.neighbor((TagKey<Biome>)BiomeTags.IS_BEACH));
    public static final Criterion OCEANSIDE = CriterionBuilder.allOf(NEAR_BORDER, CriterionBuilder.neighbor((TagKey<Biome>)BiomeTags.IS_OCEAN));
    public static final Criterion RIVERSIDE = CriterionBuilder.allOf(NEAR_BORDER, CriterionBuilder.neighbor((TagKey<Biome>)BiomeTags.IS_RIVER));

    public static Criterion not(Criterion criterion) {
        return new NotCriterion(criterion);
    }

    public static Criterion allOf(List<Criterion> criteria) {
        return new AllOfCriterion(criteria);
    }

    public static Criterion allOf(Criterion ... criteria) {
        return CriterionBuilder.allOf(List.of(criteria));
    }

    public static Criterion anyOf(List<Criterion> criteria) {
        return new AnyOfCriterion(criteria);
    }

    public static Criterion anyOf(Criterion ... criteria) {
        return CriterionBuilder.anyOf(List.of(criteria));
    }

    public static Criterion value(BiomeParameterTargets parameter, float min, float max) {
        return new ValueCriterion(parameter, min, max);
    }

    public static Criterion valueMin(BiomeParameterTargets parameter, float min) {
        return CriterionBuilder.value(parameter, min, Float.POSITIVE_INFINITY);
    }

    public static Criterion valueMax(BiomeParameterTargets parameter, float max) {
        return CriterionBuilder.value(parameter, Float.NEGATIVE_INFINITY, max);
    }

    public static Criterion deviation(BiomeParameterTargets parameter, float min, float max) {
        return new DeviationCriterion(parameter, min, max);
    }

    public static Criterion deviationMin(BiomeParameterTargets parameter, float min) {
        return CriterionBuilder.deviation(parameter, min, Float.POSITIVE_INFINITY);
    }

    public static Criterion deviationMax(BiomeParameterTargets parameter, float max) {
        return CriterionBuilder.deviation(parameter, Float.NEGATIVE_INFINITY, max);
    }

    public static Criterion ratio(RatioTargets target, float min, float max) {
        return new RatioCriterion(target, min, max);
    }

    public static Criterion ratioMin(RatioTargets target, float min) {
        return CriterionBuilder.ratio(target, min, Float.POSITIVE_INFINITY);
    }

    public static Criterion ratioMax(RatioTargets target, float max) {
        return CriterionBuilder.ratio(target, Float.NEGATIVE_INFINITY, max);
    }

    public static Criterion original(ResourceKey<Biome> biome) {
        return new OriginalCriterion(AbstractBiomeCriterion.BiomeTarget.of(biome));
    }

    public static Criterion original(TagKey<Biome> tag) {
        return new OriginalCriterion(AbstractBiomeCriterion.BiomeTarget.of(tag));
    }

    public static Criterion neighbor(ResourceKey<Biome> biome) {
        return new NeighborCriterion(AbstractBiomeCriterion.BiomeTarget.of(biome));
    }

    public static Criterion neighbor(TagKey<Biome> tag) {
        return new NeighborCriterion(AbstractBiomeCriterion.BiomeTarget.of(tag));
    }

    public static Criterion alternate(ResourceKey<Biome> biome, ResourceKey<Biome> alternate) {
        return new AlternateCriterion(AbstractBiomeCriterion.BiomeTarget.of(biome), alternate);
    }

    public static Criterion alternate(TagKey<Biome> tag, ResourceKey<Biome> alternate) {
        return new AlternateCriterion(AbstractBiomeCriterion.BiomeTarget.of(tag), alternate);
    }
}

