/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.commands.BiolithDescribeCommand;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.biolith.impl.noise.OpenSimplexNoise2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DimensionBiomePlacement {
    protected boolean biomesInjected = false;
    protected ServerLevel world;
    protected BiolithState state;
    protected OpenSimplexNoise2 replacementNoise;
    protected int[] seedlets = new int[8];
    protected Random seedRandom;
    protected final Collection<PlacementRequest> placementRequests = new HashSet<PlacementRequest>(256);
    protected final Collection<RemovalRequest> removalRequests = new HashSet<RemovalRequest>(256);
    protected final HashMap<ResourceKey<Biome>, ReplacementRequestSet> replacementRequests = new HashMap(256);
    protected final HashMap<ResourceKey<Biome>, SubBiomeRequestSet> subBiomeRequests = new HashMap(256);
    public static final Climate.Parameter DEFAULT_PARAMETER = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    public static final Climate.ParameterPoint OUT_OF_RANGE = Climate.parameters((float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f);
    public static final ResourceKey<Biome> VANILLA_PLACEHOLDER = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biolith", (String)"vanilla"));
    protected static final ThreadLocal<Vec3i> EVALUATING_BIOME_POS = new ThreadLocal();
    protected static final ThreadLocal<ServerLevel> EVALUATING_WORLD = new ThreadLocal();

    protected void serverReplaced(BiolithState state, ServerLevel world) {
        long seed = world.getSeed();
        this.world = world;
        this.state = state;
        this.replacementNoise = new OpenSimplexNoise2(seed);
        this.seedRandom = new Random(seed);
        this.replacementRequests.forEach((biomeKey, requestSet) -> requestSet.complete(BiomeCoordinator.getBiomeLookupOrThrow()));
        this.subBiomeRequests.forEach((biomeKey, requestSet) -> requestSet.complete(BiomeCoordinator.getBiomeLookupOrThrow()));
        for (int i = 0; i < 8; ++i) {
            this.seedlets[i] = (int)(seed >> i * 8 & 0xFFL);
        }
    }

    protected void serverStopped() {
        this.biomesInjected = false;
        this.state = null;
        this.world = null;
        this.replacementRequests.forEach((key, list) -> list.reopen());
        this.subBiomeRequests.forEach((key, list) -> list.reopen());
    }

    public void addPlacement(ResourceKey<Biome> biome, Climate.ParameterPoint noisePoint, boolean fromData) {
        if (this.biomesInjected) {
            Biolith.LOGGER.error("Biolith's BiomePlacement.addPlacement() called too late for biome: {}", (Object)biome.location());
        } else {
            this.placementRequests.add(new PlacementRequest(noisePoint, biome, fromData));
        }
    }

    public void addRemoval(ResourceKey<Biome> biome, boolean fromData) {
        if (this.biomesInjected) {
            Biolith.LOGGER.error("Biolith's BiomePlacement.addRemoval() called too late for biome: {}", (Object)biome.location());
        } else {
            this.removalRequests.add(new RemovalRequest(biome, fromData));
        }
    }

    public void addReplacement(ResourceKey<Biome> target, ResourceKey<Biome> biome, double rate, boolean fromData) {
        if (this.biomesInjected || this.replacementRequests.containsKey(target) && this.replacementRequests.get(target).finalized) {
            Biolith.LOGGER.error("Biolith's BiomePlacement.addReplacement() called too late for biome: {}", (Object)biome.location());
        } else {
            this.replacementRequests.computeIfAbsent(target, x$0 -> new ReplacementRequestSet((ResourceKey<Biome>)x$0)).addRequest(biome, rate, fromData);
        }
    }

    public void addSubBiome(ResourceKey<Biome> target, ResourceKey<Biome> biome, Criterion criterion, boolean fromData) {
        if (this.biomesInjected || this.subBiomeRequests.containsKey(target) && this.subBiomeRequests.get(target).finalized) {
            Biolith.LOGGER.error("Biolith's BiomePlacement.addSubBiome() called too late for biome: {}", (Object)biome.location());
        } else {
            this.subBiomeRequests.computeIfAbsent(target, x$0 -> new SubBiomeRequestSet((ResourceKey<Biome>)x$0)).addRequest(biome, criterion, fromData);
        }
    }

    public void clearFromData() {
        this.placementRequests.removeIf(PlacementRequest::fromData);
        this.removalRequests.removeIf(RemovalRequest::fromData);
        this.replacementRequests.forEach((key, set) -> set.requests.removeIf(ReplacementRequest::fromData));
        this.subBiomeRequests.forEach((key, set) -> set.requests.removeIf(SubBiomeRequest::fromData));
    }

    public Holder<Biome> getReplacement(int x, int y, int z, Climate.TargetPoint noisePoint, BiolithFittestNodes<Holder<Biome>> fittestNodes) {
        Record request;
        Holder<Biome> biomeEntry = (Holder<Biome>)fittestNodes.ultimate().value;
        ResourceKey<Biome> biomeKey = (ResourceKey<Biome>)biomeEntry.unwrapKey().orElseThrow();
        double localNoise = -1.0;
        InclusiveRange<Float> localRange = null;
        if (this.replacementRequests.containsKey(biomeKey)) {
            localNoise = this.getLocalNoise(x, y, z);
            request = this.replacementRequests.get(biomeKey).selectReplacement(localNoise);
            if (request != null) {
                localRange = ((ReplacementRequest)request).range();
                if (!((ReplacementRequest)request).biome().equals(VANILLA_PLACEHOLDER)) {
                    biomeEntry = ((ReplacementRequest)request).biomeEntry();
                    biomeKey = ((ReplacementRequest)request).biome();
                }
            }
        }
        if (this.subBiomeRequests.containsKey(biomeKey)) {
            if (localNoise < 0.0) {
                localNoise = this.getLocalNoise(x, y, z);
            }
            EVALUATING_BIOME_POS.set(new Vec3i(x, y, z));
            EVALUATING_WORLD.set(this.world);
            request = this.subBiomeRequests.get(biomeKey).selectSubBiome(fittestNodes, noisePoint, localRange, localNoise);
            if (request != null) {
                biomeEntry = ((SubBiomeRequest)request).biomeEntry();
                biomeKey = ((SubBiomeRequest)request).biome();
            }
        }
        return biomeEntry;
    }

    public BiolithDescribeCommand.DescribeBiomeData getBiomeData(int x, int y, int z, Climate.TargetPoint noisePoint, BiolithFittestNodes<Holder<Biome>> fittestNodes) {
        Holder biomeEntry = (Holder)fittestNodes.ultimate().value;
        ResourceKey biomeKey = (ResourceKey)biomeEntry.unwrapKey().orElseThrow();
        double localNoise = this.getLocalNoise(x, y, z);
        ReplacementRequest lowerRequest = null;
        ReplacementRequest replacementRequest = null;
        ReplacementRequest higherRequest = null;
        SubBiomeRequest subBiomeRequest = null;
        if (this.replacementRequests.containsKey(biomeKey)) {
            for (ReplacementRequest request : this.replacementRequests.get((Object)biomeKey).requests) {
                if (request.end >= localNoise) {
                    if (replacementRequest == null) {
                        replacementRequest = request;
                        continue;
                    }
                    higherRequest = request;
                    break;
                }
                lowerRequest = request;
            }
        }
        EVALUATING_BIOME_POS.set(new Vec3i(x, y, z));
        EVALUATING_WORLD.set(this.world);
        if (replacementRequest == null) {
            if (this.subBiomeRequests.containsKey(biomeKey)) {
                subBiomeRequest = this.subBiomeRequests.get(biomeKey).selectSubBiome(fittestNodes, noisePoint, null, localNoise);
            }
        } else if (this.subBiomeRequests.containsKey(replacementRequest.biome())) {
            subBiomeRequest = this.subBiomeRequests.get(replacementRequest.biome()).selectSubBiome(fittestNodes, noisePoint, replacementRequest.range(), localNoise);
        }
        return new BiolithDescribeCommand.DescribeBiomeData(replacementRequest == null ? null : replacementRequest.range(), (ResourceKey<Biome>)(replacementRequest == null ? null : (replacementRequest.biome().equals(VANILLA_PLACEHOLDER) ? (ResourceKey)((Holder)fittestNodes.ultimate().value).unwrapKey().orElseThrow() : replacementRequest.biome())), lowerRequest == null ? null : (lowerRequest.biome().equals(VANILLA_PLACEHOLDER) ? (ResourceKey)((Holder)fittestNodes.ultimate().value).unwrapKey().orElseThrow() : lowerRequest.biome()), higherRequest == null ? null : (higherRequest.biome().equals(VANILLA_PLACEHOLDER) ? (ResourceKey)((Holder)fittestNodes.ultimate().value).unwrapKey().orElseThrow() : higherRequest.biome()), subBiomeRequest == null || subBiomeRequest.biome().equals(VANILLA_PLACEHOLDER) ? null : subBiomeRequest.biome());
    }

    @NotNull
    public Holder<Biome> getReplacementEntry(int x, int y, int z, @NotNull Holder<Biome> biomeEntry) {
        ReplacementRequest request;
        ResourceKey biomeKey = (ResourceKey)biomeEntry.unwrapKey().orElseThrow();
        if (this.replacementRequests.containsKey(biomeKey) && (request = this.replacementRequests.get(biomeKey).selectReplacement(this.getLocalNoise(x, y, z))) != null && !request.biome().equals(VANILLA_PLACEHOLDER)) {
            biomeEntry = request.biomeEntry();
        }
        return biomeEntry;
    }

    @Nullable
    public Pair<ResourceKey<Biome>, Holder<Biome>> getReplacementPair(@Nullable ResourceKey<Biome> biomeKey, float replacementNoise) {
        ReplacementRequest request;
        if (biomeKey != null && this.replacementRequests.containsKey(biomeKey) && (request = this.replacementRequests.get(biomeKey).selectReplacement(replacementNoise)) != null && request.biome != null) {
            return Pair.of(request.biome, request.biomeEntry);
        }
        return null;
    }

    public static Vec3i getEvaluatingBiomePos() {
        return EVALUATING_BIOME_POS.get();
    }

    public static ServerLevel getEvaluatingWorld() {
        return EVALUATING_WORLD.get();
    }

    public void writeBiomeEntries(Consumer<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters) {
        this.biomesInjected = true;
        HolderGetter<Biome> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.placementRequests.forEach(request -> parameters.accept(request.pair().mapSecond(arg_0 -> ((HolderGetter)biomeEntryGetter).getOrThrow(arg_0))));
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.getOrThrow(biome)));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.getOrThrow(biome))));
    }

    public boolean removalFilter(Pair<Climate.ParameterPoint, Holder<Biome>> entryPair) {
        for (RemovalRequest removalRequest : this.removalRequests) {
            if (!((Holder)entryPair.getSecond()).is(removalRequest.biome)) continue;
            return false;
        }
        return true;
    }

    public abstract double getLocalNoise(int var1, int var2, int var3);

    protected double normalize(double value) {
        return Mth.clamp((double)(value * 0.5375 + 0.5), (double)0.0, (double)1.0);
    }

    protected record PlacementRequest(Climate.ParameterPoint hypercube, ResourceKey<Biome> biome, boolean fromData) {
        public Pair<Climate.ParameterPoint, ResourceKey<Biome>> pair() {
            return Pair.of((Object)this.hypercube, this.biome);
        }
    }

    protected record RemovalRequest(ResourceKey<Biome> biome, boolean fromData) {
    }

    protected class ReplacementRequestSet {
        private boolean finalized = false;
        ResourceKey<Biome> target;
        List<ReplacementRequest> requests = new ArrayList<ReplacementRequest>(8);

        ReplacementRequestSet(ResourceKey<Biome> target) {
            this.target = target;
        }

        void addRequest(ResourceKey<Biome> biome, double rate, boolean fromData) {
            this.addRequest(ReplacementRequest.of(biome, rate, fromData));
        }

        void addRequest(ReplacementRequest request) {
            if (this.requests.contains(request)) {
                Biolith.LOGGER.info("Ignoring request for duplicate biome replacement: {}", request.biome);
            } else {
                this.requests.add(request);
            }
        }

        @Nullable
        public ReplacementRequest selectReplacement(double localNoise) {
            for (ReplacementRequest request : this.requests) {
                if (!(request.end >= localNoise)) continue;
                return request;
            }
            return null;
        }

        void complete(HolderGetter<Biome> biomeEntryGetter) {
            double maxRate = 0.0;
            if (this.finalized) {
                throw new IllegalStateException("Attempted to finalize replacement requests without first reopening!");
            }
            this.requests.removeIf(request -> request.biome.equals(VANILLA_PLACEHOLDER));
            double locus = 0.0;
            for (ReplacementRequest request2 : this.requests) {
                locus += request2.rate;
                if (!(request2.rate > maxRate)) continue;
                maxRate = request2.rate;
            }
            double vanilla = Mth.clamp((double)(1.0 - maxRate), (double)0.0, (double)1.0);
            double scale = locus + vanilla;
            if (vanilla > 0.0) {
                this.requests.add(ReplacementRequest.of(VANILLA_PLACEHOLDER, vanilla, false));
            }
            Collections.shuffle(this.requests, DimensionBiomePlacement.this.seedRandom);
            DimensionBiomePlacement.this.state.addBiomeReplacements(this.target, this.requests.stream().map(ReplacementRequest::biome));
            List<ResourceKey<Biome>> sortOrder = DimensionBiomePlacement.this.state.getBiomeReplacements(this.target).toList();
            this.requests.sort(Comparator.comparingInt(request -> sortOrder.indexOf(request.biome)));
            locus = 0.0;
            for (int i = 0; i < this.requests.size(); ++i) {
                ReplacementRequest request3 = this.requests.get(i);
                this.requests.set(i, request3.complete(biomeEntryGetter, locus, locus += request3.rate / scale));
            }
            this.requests = List.copyOf(this.requests);
            this.finalized = true;
        }

        void reopen() {
            if (BiomeCoordinator.isServerStarted()) {
                throw new IllegalStateException("Attempted to reopen replacement requests while server is running!");
            }
            this.requests = new ArrayList<ReplacementRequest>(this.requests);
            this.finalized = false;
        }
    }

    protected class SubBiomeRequestSet {
        private boolean finalized = false;
        ResourceKey<Biome> target;
        List<SubBiomeRequest> requests = new ArrayList<SubBiomeRequest>(8);

        SubBiomeRequestSet(ResourceKey<Biome> target) {
            this.target = target;
        }

        void addRequest(ResourceKey<Biome> biome, Criterion criterion, boolean fromData) {
            this.addRequest(SubBiomeRequest.of(biome, criterion, fromData));
        }

        void addRequest(SubBiomeRequest request) {
            if (this.requests.contains(request)) {
                Biolith.LOGGER.info("Ignoring request for duplicate sub-biome: {} -> {}", this.target, request.biome);
            } else {
                this.requests.add(request);
            }
        }

        @Nullable
        public SubBiomeRequest selectSubBiome(BiolithFittestNodes<Holder<Biome>> fittestNodes, Climate.TargetPoint noisePoint, @Nullable InclusiveRange<Float> localRange, double localNoise) {
            for (SubBiomeRequest request : this.requests) {
                if (!request.criterion().matches(fittestNodes, DimensionBiomePlacement.this, noisePoint, localRange, (float)localNoise)) continue;
                return request;
            }
            return null;
        }

        void complete(HolderGetter<Biome> biomeEntryGetter) {
            if (this.finalized) {
                throw new IllegalStateException("Attempted to finalize sub-biome requests without first reopening!");
            }
            this.requests = this.requests.stream().map(request -> request.complete(biomeEntryGetter)).sorted(Comparator.comparing(request -> request.biome.location())).toList();
            this.finalized = true;
        }

        void reopen() {
            if (BiomeCoordinator.isServerStarted()) {
                throw new IllegalStateException("Attempted to reopen sub-biome requests while server is running!");
            }
            this.requests = this.requests.stream().map(SubBiomeRequest::reopen).collect(Collectors.toCollection(ArrayList::new));
            this.finalized = false;
        }
    }

    protected record ReplacementRequest(ResourceKey<Biome> biome, double rate, Holder<Biome> biomeEntry, double start, double end, boolean fromData) {
        public ReplacementRequest {
            rate = Mth.clamp((double)rate, (double)0.0, (double)1.0);
        }

        static ReplacementRequest of(ResourceKey<Biome> biome, double rate, boolean fromData) {
            return new ReplacementRequest(biome, rate, null, 0.0, 0.0, fromData);
        }

        public InclusiveRange<Float> range() {
            return new InclusiveRange((Comparable)Float.valueOf((float)this.start), (Comparable)Float.valueOf(this.end > 0.9999 ? 1.0f : (float)this.end));
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof ReplacementRequest) {
                ReplacementRequest request = (ReplacementRequest)object;
                return request.biome.equals(this.biome) && request.rate == this.rate;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.biome.hashCode();
        }

        ReplacementRequest complete(HolderGetter<Biome> biomeEntryGetter, double start, double end) {
            if (this.biome.equals(VANILLA_PLACEHOLDER)) {
                return new ReplacementRequest(this.biome, this.rate, null, start, end, false);
            }
            return new ReplacementRequest(this.biome, this.rate, (Holder<Biome>)biomeEntryGetter.getOrThrow(this.biome), start, end, this.fromData);
        }
    }

    protected record SubBiomeRequest(ResourceKey<Biome> biome, Criterion criterion, Holder<Biome> biomeEntry, boolean fromData) {
        static SubBiomeRequest of(ResourceKey<Biome> biome, Criterion criterion, boolean fromData) {
            return new SubBiomeRequest(biome, criterion, null, fromData);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof SubBiomeRequest) {
                SubBiomeRequest request = (SubBiomeRequest)object;
                return request.biome.equals(this.biome) && request.criterion.equals(this.criterion);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.biome.hashCode();
        }

        SubBiomeRequest complete(HolderGetter<Biome> biomeEntryGetter) {
            this.criterion.complete(biomeEntryGetter);
            return new SubBiomeRequest(this.biome, this.criterion, (Holder<Biome>)biomeEntryGetter.getOrThrow(this.biome), this.fromData);
        }

        SubBiomeRequest reopen() {
            this.criterion.reopen();
            return this;
        }
    }
}

