/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome.sub;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionType;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.sub.BiolithCriteria;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;

public record AllOfCriterion(List<Criterion> criteria) implements Criterion
{
    public static final MapCodec<AllOfCriterion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Criterion.CODEC.listOf().fieldOf("criteria").forGetter(AllOfCriterion::criteria)).apply((Applicative)instance, AllOfCriterion::new));

    public CriterionType<AllOfCriterion> getType() {
        return BiolithCriteria.ALL_OF;
    }

    public MapCodec<AllOfCriterion> getCodec() {
        return CODEC;
    }

    @Override
    public boolean matches(BiolithFittestNodes<Holder<Biome>> fittestNodes, DimensionBiomePlacement biomePlacement, Climate.TargetPoint noisePoint, @Nullable InclusiveRange<Float> replacementRange, float replacementNoise) {
        for (Criterion criterion : this.criteria) {
            if (criterion.matches(fittestNodes, biomePlacement, noisePoint, replacementRange, replacementNoise)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void complete(HolderGetter<Biome> biomeEntryGetter) {
        this.criteria.forEach(criterion -> criterion.complete(biomeEntryGetter));
    }

    @Override
    public void reopen() {
        this.criteria.forEach(Criterion::reopen);
    }
}

