/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome.sub;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.api.biome.sub.CriterionType;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.sub.AbstractBiomeCriterion;
import com.terraformersmc.biolith.impl.biome.sub.BiolithCriteria;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;

public class AlternateCriterion
extends AbstractBiomeCriterion {
    public static final MapCodec<AlternateCriterion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbstractBiomeCriterion.BiomeTarget.CODEC.fieldOf("biome").forGetter(AbstractBiomeCriterion::biomeTarget), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("alternate").forGetter(AlternateCriterion::alternate)).apply((Applicative)instance, AlternateCriterion::new));
    private final ResourceKey<Biome> alternate;
    private Holder<Biome> alternateEntry;

    public AlternateCriterion(AbstractBiomeCriterion.BiomeTarget biomeTarget, ResourceKey<Biome> alternate) {
        super(biomeTarget);
        this.alternate = alternate;
    }

    public ResourceKey<Biome> alternate() {
        return this.alternate;
    }

    public CriterionType<AlternateCriterion> getType() {
        return BiolithCriteria.ALTERNATE;
    }

    public MapCodec<AlternateCriterion> getCodec() {
        return CODEC;
    }

    @Override
    public boolean matches(BiolithFittestNodes<Holder<Biome>> fittestNodes, DimensionBiomePlacement biomePlacement, Climate.TargetPoint noisePoint, @Nullable InclusiveRange<Float> replacementRange, float replacementNoise) {
        Pair<ResourceKey<Biome>, Holder<Biome>> replacement = biomePlacement.getReplacementPair(this.alternate, replacementNoise);
        if (replacement == null || ((ResourceKey)replacement.getFirst()).equals(DimensionBiomePlacement.VANILLA_PLACEHOLDER)) {
            return this.biomeTarget.matches(this.alternateEntry);
        }
        return this.biomeTarget.matches((Holder<Biome>)((Holder)replacement.getSecond()));
    }

    @Override
    public void complete(HolderGetter<Biome> biomeEntryGetter) {
        this.alternateEntry = biomeEntryGetter.getOrThrow(this.alternate);
    }

    @Override
    public void reopen() {
        this.alternateEntry = null;
    }
}

