/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome.sub;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionType;
import com.terraformersmc.biolith.api.biome.sub.RatioTargets;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.sub.BiolithCriteria;
import net.minecraft.core.Holder;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;

public record RatioCriterion(RatioTargets target, InclusiveRange<Float> allowedValues) implements Criterion
{
    public static final MapCodec<RatioCriterion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RatioTargets.CODEC.fieldOf("target").forGetter(RatioCriterion::target), (App)Codec.FLOAT.optionalFieldOf("min", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(RatioCriterion::min), (App)Codec.FLOAT.optionalFieldOf("max", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(RatioCriterion::max)).apply((Applicative)instance, RatioCriterion::new));

    public RatioCriterion(RatioTargets target, float min, float max) {
        this(target, (InclusiveRange<Float>)new InclusiveRange((Comparable)Float.valueOf(min), (Comparable)Float.valueOf(max)));
    }

    public float min() {
        return ((Float)this.allowedValues.minInclusive()).floatValue();
    }

    public float max() {
        return ((Float)this.allowedValues.maxInclusive()).floatValue();
    }

    @Override
    public CriterionType<? extends Criterion> getType() {
        return BiolithCriteria.RATIO;
    }

    @Override
    public MapCodec<? extends Criterion> getCodec() {
        return CODEC;
    }

    @Override
    public boolean matches(BiolithFittestNodes<Holder<Biome>> fittestNodes, DimensionBiomePlacement biomePlacement, Climate.TargetPoint noisePoint, @Nullable InclusiveRange<Float> replacementRange, float replacementNoise) {
        float comparable;
        if (this.target == RatioTargets.CENTER) {
            comparable = Mth.sqrt((float)BiomeParameterTargets.getSquaredDistance(BiomeParameterTargets.parametersCenterPoint(fittestNodes.ultimate().parameterSpace), noisePoint, fittestNodes.ultimate().parameterSpace[6].min())) / 10000.0f;
            if (replacementRange != null) {
                if (((Float)replacementRange.minInclusive()).floatValue() <= 0.0f) {
                    if (((Float)replacementRange.maxInclusive()).floatValue() < 1.0f) {
                        comparable = Math.max(replacementNoise, comparable);
                    }
                } else {
                    comparable = ((Float)replacementRange.maxInclusive()).floatValue() >= 1.0f ? Math.max(1.0f - replacementNoise, comparable) : Math.max(Math.abs(replacementNoise - (((Float)replacementRange.minInclusive()).floatValue() + ((Float)replacementRange.maxInclusive()).floatValue()) / 2.0f), comparable);
                }
            }
        } else if (this.target == RatioTargets.EDGE) {
            comparable = fittestNodes.penultimate() == null ? 1.0f : (fittestNodes.penultimateDistance() == 0L ? 0.0f : (float)(fittestNodes.penultimateDistance() - fittestNodes.ultimateDistance()) / (float)fittestNodes.penultimateDistance());
            if (replacementRange != null) {
                if (((Float)replacementRange.minInclusive()).floatValue() <= 0.0f) {
                    if (((Float)replacementRange.maxInclusive()).floatValue() < 1.0f) {
                        comparable = Math.min(((Float)replacementRange.maxInclusive()).floatValue() - replacementNoise, comparable);
                    }
                } else {
                    comparable = ((Float)replacementRange.maxInclusive()).floatValue() >= 1.0f ? Math.min(replacementNoise - ((Float)replacementRange.minInclusive()).floatValue(), comparable) : Math.min(Math.min(replacementNoise - ((Float)replacementRange.minInclusive()).floatValue(), ((Float)replacementRange.maxInclusive()).floatValue() - replacementNoise), comparable);
                }
            }
        } else {
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.target));
        }
        return this.allowedValues.isValueInRange((Comparable)Float.valueOf(comparable));
    }
}

