/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.compat;

import com.mojang.brigadier.context.CommandContext;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.commands.BiolithDescribeCommand;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class ModernerBetaCompatNeoForge {
    public static int describe(CommandContext<CommandSourceStack> context, int biomeX, int biomeY, int biomeZ, ServerLevel world, BiomeSource biomeSource, Climate.ParameterList<Holder<Biome>> biomeEntries, Climate.Sampler noise) {
        if (!(biomeSource instanceof ModernBetaBiomeSource)) {
            return 0;
        }
        Holder original = ((ModernBetaBiomeSource)biomeSource).getBiomeProvider().getBiome(biomeX, biomeY, biomeZ);
        BiolithFittestNodes<Holder<Biome>> fittestNodes = new BiolithFittestNodes<Holder<Biome>>(new Climate.RTree.Leaf(DimensionBiomePlacement.OUT_OF_RANGE, (Object)original), 0L, null, Integer.MAX_VALUE);
        double replacementNoise = BiomeCoordinator.OVERWORLD.getLocalNoise(biomeX, biomeY, biomeZ);
        int replacementScale = Biolith.getConfigManager().getGeneralConfig().getOverworldReplacementScale();
        BiolithDescribeCommand.DescribeBiomeData describeBiomeData = BiomeCoordinator.OVERWORLD.getBiomeData(biomeX, biomeY, biomeZ, new Climate.TargetPoint(0L, 0L, 0L, 0L, 0L, 0L), fittestNodes);
        String worldTranslationKey = world.dimension().location().toLanguageKey();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7nBiolith ").append((Component)Component.translatable((String)worldTranslationKey).withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.literal((String)"\u00a7n (")).append((Component)Component.translatable((String)"biolith.command.describe.biome.scale").withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.literal((String)("\u00a7n: " + replacementScale + ") "))).append((Component)Component.translatable((String)"biolith.command.describe.header").withStyle(ChatFormatting.UNDERLINE)));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("\u00a76BR\u00a7r:%+05.3f", replacementNoise)));
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.biome.moderner_beta").append((Component)BiolithDescribeCommand.textFromBiome((Holder<Biome>)original)));
        if (describeBiomeData.replacementBiome() != null && describeBiomeData.replacementRange() == null) {
            return -2;
        }
        if (describeBiomeData.replacementBiome() != null) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"biolith.command.describe.biome.replacement").append((Component)BiolithDescribeCommand.textFromBiome(describeBiomeData.replacementBiome())).append((Component)Component.literal((String)"\n    ")).append((Component)(describeBiomeData.lowerBiome() == null ? Component.translatable((String)"biolith.command.describe.biome.none") : BiolithDescribeCommand.textFromBiome(describeBiomeData.lowerBiome()))).append((Component)Component.literal((String)" < ")).append((Component)BiolithDescribeCommand.textFromBiome(describeBiomeData.replacementBiome())).append((Component)Component.literal((String)" < ")).append((Component)(describeBiomeData.higherBiome() == null ? Component.translatable((String)"biolith.command.describe.biome.none") : BiolithDescribeCommand.textFromBiome(describeBiomeData.higherBiome()))).append((Component)Component.literal((String)String.format("\n    %+05.3f < %+05.3f < %+05.3f ", describeBiomeData.replacementRange().minInclusive(), replacementNoise, describeBiomeData.replacementRange().maxInclusive()))));
        }
        return 1;
    }
}

