/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.feature;

import com.google.common.collect.ImmutableList;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.terraformersmc.biolith.impl.Biolith;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.NotNull;

public class ResilientPlacedFeatureIndexer {
    private static final IndexedFeature ROOT_FEATURE = new IndexedFeature((Holder<PlacedFeature>)Holder.direct((Object)new PlacedFeature(null, null)), -1);

    public static <T> List<FeatureSorter.StepFeatureData> collectIndexedFeatures(List<T> biomes, Function<T, List<HolderSet<PlacedFeature>>> biomesToPlacedFeaturesList) {
        int featureSteps = 0;
        MutableGraph graph = GraphBuilder.directed().expectedNodeCount(1024).nodeOrder(ElementOrder.insertion()).incidentEdgeOrder(ElementOrder.stable()).allowsSelfLoops(false).build();
        graph.addNode((Object)ROOT_FEATURE);
        for (T biome : biomes) {
            List<HolderSet<PlacedFeature>> featureEntryLists = biomesToPlacedFeaturesList.apply(biome);
            featureSteps = Math.max(featureSteps, featureEntryLists.size());
            IndexedFeature previous = ROOT_FEATURE;
            for (int step = 0; step < featureEntryLists.size(); ++step) {
                for (Holder featureEntry : featureEntryLists.get(step)) {
                    IndexedFeature current = new IndexedFeature((Holder<PlacedFeature>)featureEntry, step);
                    if (graph.nodes().contains(current) && Graphs.reachableNodes((Graph)graph, (Object)current).contains(previous)) {
                        Biolith.LOGGER.info("Dropping cycle-forming edge in biome {}: {} -> {}", new Object[]{ResilientPlacedFeatureIndexer.getEntryString(biome), previous, current});
                    } else {
                        try {
                            graph.putEdge((Object)previous, (Object)current);
                        }
                        catch (IllegalArgumentException e) {
                            Biolith.LOGGER.info("Dropping self-edge in biome {}: {}", (Object)ResilientPlacedFeatureIndexer.getEntryString(biome), (Object)current);
                        }
                    }
                    previous = current;
                }
            }
        }
        List[] stepwiseLists = new ArrayList[featureSteps];
        for (int step = 0; step < featureSteps; ++step) {
            stepwiseLists[step] = new ArrayList(128);
        }
        Traverser.forGraph((SuccessorsFunction)graph).depthFirstPostOrder((Object)ROOT_FEATURE).forEach(node -> {
            if (node.step >= 0) {
                stepwiseLists[node.step].add((PlacedFeature)node.featureEntry.value());
            }
        });
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int step = 0; step < featureSteps; ++step) {
            Collections.reverse(stepwiseLists[step]);
            builder.add((Object)new FeatureSorter.StepFeatureData(stepwiseLists[step]));
        }
        return builder.build();
    }

    private static <T> String getEntryString(T thing) {
        if (thing instanceof Holder) {
            Holder entry = (Holder)thing;
            return entry.getRegisteredName();
        }
        return thing.toString();
    }

    record IndexedFeature(Holder<PlacedFeature> featureEntry, int step) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof IndexedFeature)) return false;
            IndexedFeature other = (IndexedFeature)o;
            if (this.step != other.step) return false;
            if (!this.featureEntry.equals(other.featureEntry)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.featureEntry.hashCode() ^ this.step;
        }

        @Override
        @NotNull
        public String toString() {
            return this.featureEntry.getRegisteredName();
        }
    }
}

