/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ThornPendantItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"poison").stat(StatData.builder((String)"multiplier").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"time").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"chance").initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).research(ResearchData.builder().star(0, 10, 18).star(1, 4, 14).star(2, 11, 13).star(3, 16, 16).star(4, 12, 29).link(1, 0).link(2, 0).link(3, 0).link(4, 0).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-16733141).borderBottom(-16759255).build()).beams(BeamsData.builder().startColor(-16733141).endColor(17961).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"poison").initialValue(1).gem(GemShape.SQUARE, GemColor.GREEN).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.TROPIC}).build()).build();
    }

    @EventBusSubscriber
    public static class ThornPendantEvent {
        @SubscribeEvent
        public static void onReceivingDamage(LivingDamageEvent.Post event) {
            ThornPendantItem relic;
            Item item;
            LivingEntity attacker;
            Player player;
            block5: {
                block4: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block4;
                    player = (Player)livingEntity;
                    livingEntity = event.getSource().getEntity();
                    if (livingEntity instanceof LivingEntity && !(attacker = livingEntity).getStringUUID().equals(player.getStringUUID())) break block5;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.THORN_PENDANT.value()));
            RandomSource random = player.getRandom();
            Level level = player.getCommandSenderWorld();
            if (level.isClientSide() || !((item = stack.getItem()) instanceof ThornPendantItem) || !(relic = (ThornPendantItem)item).canPlayerUseAbility(player, stack, "poison") || random.nextDouble() > relic.getStatValue(stack, "poison", "chance")) {
                return;
            }
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            attacker.invulnerableTime = 0;
            attacker.hurt(level.damageSources().thorns((Entity)player), (float)((double)event.getNewDamage() * relic.getStatValue(stack, "poison", "multiplier")));
            attacker.addEffect(new MobEffectInstance(MobEffects.POISON, (int)(relic.getStatValue(stack, "poison", "time") * 20.0), 1));
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(50 + random.nextInt(50), 200 + random.nextInt(55), 50 + random.nextInt(50)), (float)0.4f, (int)30, (float)0.95f), attacker.getX(), attacker.getY() + (double)(attacker.getBbHeight() / 2.0f), attacker.getZ(), 10, (double)(attacker.getBbWidth() / 2.0f), (double)(attacker.getBbHeight() / 2.0f), (double)(attacker.getBbWidth() / 2.0f), (double)0.025f);
        }
    }
}

