/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.client.screen.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ToggleButton
extends Button {
    private boolean isEnabled;
    private int ENABLE_COLOR;
    private int DISABLE_COLOR;

    public ToggleButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, boolean initialState, int enableColor, int disableColor) {
        super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
        this.ENABLE_COLOR = enableColor;
        this.DISABLE_COLOR = disableColor;
        this.isEnabled = initialState;
    }

    public void setColors(int enableColor, int disableColor) {
        this.ENABLE_COLOR = enableColor;
        this.DISABLE_COLOR = disableColor;
    }

    public void setToggleState(boolean state) {
        this.isEnabled = state;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int borderColor = -16777216;
        guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY(), borderColor);
        guiGraphics.fill(this.getX() - 1, this.getY(), this.getX(), this.getY() + this.height, borderColor);
        guiGraphics.fill(this.getX() + this.width, this.getY(), this.getX() + this.width + 1, this.getY() + this.height, borderColor);
        guiGraphics.fill(this.getX() - 1, this.getY() + this.height, this.getX() + this.width + 1, this.getY() + this.height + 1, borderColor);
        int backgroundColor = this.isEnabled ? this.ENABLE_COLOR : this.DISABLE_COLOR;
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, backgroundColor);
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.drawCenteredString(mc.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, 0xFFFFFF);
    }

    public void onPress() {
        super.onPress();
        this.isEnabled = !this.isEnabled;
    }
}

