/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.dragonitegear.block;

import java.util.function.Supplier;
import net.micaxs.dragonitegear.block.custom.DragoniteForgeBlock;
import net.micaxs.dragonitegear.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"dragonitegear");
    public static final DeferredBlock<Block> DRAGONITE_ORE = ModBlocks.registerBlock("dragonite_ore", () -> new Block(BlockBehaviour.Properties.of().strength(7.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> DRAGONITE_FORGE = ModBlocks.registerBlock("dragonite_forge", () -> new DragoniteForgeBlock(BlockBehaviour.Properties.of().strength(8.0f).noOcclusion().sound(SoundType.METAL).requiresCorrectToolForDrops()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

