/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.dragonitegear.item.custom;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DragoniteBow
extends BowItem {
    public DragoniteBow(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        boolean isArrowAvailable;
        ItemStack itemStack = player.getItemInHand(hand);
        boolean bl = isArrowAvailable = !player.getProjectile(itemStack).isEmpty();
        if (!level.isClientSide && isArrowAvailable) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public static boolean isUsingBow(Player player) {
        ItemStack activeItem = player.getUseItem();
        return activeItem.getItem() instanceof DragoniteBow;
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        arrow.setBaseDamage(arrow.getBaseDamage() * 4.0);
        return super.customArrow(arrow, projectileStack, weaponStack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

