---
navigation:
  title: "Add-on: MEGA Cells"
  position: 80
item_ids:
  - accumulation_processor
  - accumulation_processor_press
  - printed_accumulation_processor
  - sky_steel_ingot
  - sky_steel_block
---

# MEGA Cells

![MEGA Cells logo](assets/logo.png)

## Introduction

**MEGA Cells** is an add-on for Applied Energistics 2 providing higher tiers of storage, ranging in capacity from **1M**
to as high as **256M**, while also providing some bespoke features such as more specialised storage cells and extra
related tooling.

## Getting Started

<Row>
  <ItemImage id="sky_steel_ingot" scale="4" />
  <ItemImage id="accumulation_processor" scale="4" />
</Row>

To reach new heights on storage, new materials are needed. The most important resource you will need to gather in
preparation for setting up MEGA infrastructure is plenty of <ItemLink id="ae2:sky_stone_block" />, as this will need to
be transformed into **Sky Steel** alloy ingots together with Iron and a
<ItemLink id="ae2:charged_certus_quartz_crystal" />. Water won't be enough for metalwork, however, so you'll need a much
hotter fluid to melt these down and transform them with.

<Row>
  <Recipe id="transform/sky_steel_ingot" />
</Row>

Once you have some Sky Steel, you can use it to assemble a brand-new processor type, known as the **Accumulation
Processor**. This processor serves as the distinct "backbone" of almost every MEGA device, be they the standard
larger-capacity cells or any of the other specialised tools.

<Row>
  <RecipeFor id="accumulation_processor_press" />
  <RecipeFor id="printed_accumulation_processor" />
  <RecipeFor id="accumulation_processor" />
</Row>

From this point on, you are ready to progress further with the offerings of "*MEGA Corp.*" and unlock the full potential
of your ME storage and infrastructure.

## Further Reading

<SubPages />
