/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.api.events.server;

import com.hypherionmc.craterlib.core.event.CraterEvent;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import com.hypherionmc.craterlib.utils.ChatUtils;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shadow.kyori.adventure.text.Component;

public class CraterCommandEvent
extends CraterEvent {
    private final ParseResults<CommandSourceStack> parseResults;
    private Throwable exception;
    private final String command;

    private CraterCommandEvent(ParseResults<CommandSourceStack> parseResults, String command) {
        this.parseResults = parseResults;
        this.command = command;
    }

    public static CraterCommandEvent of(ParseResults<CommandSourceStack> stack, String command) {
        return new CraterCommandEvent(stack, command);
    }

    public String getCommandString() {
        return this.parseResults.getReader().getString();
    }

    @Nullable
    public BridgedPlayer getPlayer() {
        try {
            ServerPlayer p = ((CommandSourceStack)this.parseResults.getContext().getLastChild().getSource()).getPlayer();
            if (p != null) {
                return BridgedPlayer.of((Player)p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getTarget() {
        CommandContext context = this.parseResults.getContext().build(this.parseResults.getReader().getString());
        StringRange selector_range = ((ParsedArgument)this.parseResults.getContext().getArguments().get("targets")).getRange();
        return context.getInput().substring(selector_range.getStart(), selector_range.getEnd());
    }

    public Component getMessage() {
        return ChatUtils.mojangToAdventure(ComponentArgument.getComponent((CommandContext)this.parseResults.getContext().build(this.parseResults.getReader().getString()), (String)"message"));
    }

    public ParseResults<CommandSourceStack> getParseResults() {
        return this.parseResults;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getCommand() {
        return this.command;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }
}

