/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.nojang.server;

import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.craterlib.nojang.commands.BridgedFakePlayer;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import com.hypherionmc.craterlib.nojang.world.level.BridgedGameRules;
import com.hypherionmc.craterlib.utils.ChatUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.world.entity.player.Player;
import shadow.kyori.adventure.text.Component;

public class BridgedMinecraftServer {
    private final MinecraftServer internal;

    public boolean isUsingWhitelist() {
        return this.internal.getPlayerList().isUsingWhitelist();
    }

    public int getPlayerCount() {
        return this.internal.getPlayerList().getPlayerCount();
    }

    public int getMaxPlayers() {
        return this.internal.getPlayerList().getMaxPlayers();
    }

    public String getServerModName() {
        return this.internal.getServerModName();
    }

    public String getName() {
        return SharedConstants.getCurrentVersion().getName();
    }

    public boolean usesAuthentication() {
        return this.internal.usesAuthentication();
    }

    public void broadcastSystemMessage(Component text, boolean bl) {
        this.internal.getPlayerList().broadcastSystemMessage(ChatUtils.adventureToMojang(text), bl);
    }

    public boolean isPlayerBanned(BridgedGameProfile profile) {
        return this.internal.getPlayerList().getBans().isBanned(profile.toMojang());
    }

    public void whitelistPlayer(BridgedGameProfile gameProfile) {
        if (!this.internal.getPlayerList().isUsingWhitelist()) {
            return;
        }
        this.internal.getPlayerList().getWhiteList().add((StoredUserEntry)new UserWhiteListEntry(gameProfile.toMojang()));
    }

    public void unWhitelistPlayer(BridgedGameProfile gameProfile) {
        if (!this.internal.getPlayerList().isUsingWhitelist()) {
            return;
        }
        this.internal.getPlayerList().getWhiteList().remove((StoredUserEntry)new UserWhiteListEntry(gameProfile.toMojang()));
    }

    public List<BridgedPlayer> getPlayers() {
        ArrayList<BridgedPlayer> profiles = new ArrayList<BridgedPlayer>();
        if (this.internal.getPlayerList() == null) {
            return profiles;
        }
        this.internal.getPlayerList().getPlayers().forEach(p -> profiles.add(BridgedPlayer.of((Player)p)));
        return profiles;
    }

    public BridgedGameRules getGameRules() {
        return BridgedGameRules.bridge(this.internal.getGameRules());
    }

    public void banPlayer(BridgedGameProfile profile) {
        this.internal.getPlayerList().getBans().add((StoredUserEntry)new UserBanListEntry(profile.toMojang()));
    }

    public void executeCommand(BridgedMinecraftServer server, BridgedFakePlayer player, String command) {
        this.internal.getCommands().performPrefixedCommand(player.toMojang(), command);
    }

    public MinecraftServer toMojang() {
        return this.internal;
    }

    private BridgedMinecraftServer(MinecraftServer internal) {
        this.internal = internal;
    }

    public static BridgedMinecraftServer of(MinecraftServer internal) {
        return new BridgedMinecraftServer(internal);
    }
}

