/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common.api.pokemon;

import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.util.adapters.VerboseVec3dAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.phys.Vec3;
import net.starliteheart.cobbleride.common.CobbleRideMod;
import net.starliteheart.cobbleride.common.net.messages.client.data.RideableSpeciesRegistrySyncPacket;
import net.starliteheart.cobbleride.common.pokemon.RideableSpecies;
import net.starliteheart.cobbleride.common.util.CobbleRideUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\u00020\u001f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R \u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\t8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R \u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000-8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R0\u00104\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000202j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002`38\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006:"}, d2={"Lnet/starliteheart/cobbleride/common/api/pokemon/RideablePokemonSpecies;", "Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "Lnet/starliteheart/cobbleride/common/pokemon/RideableSpecies;", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "getByIdentifier", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/starliteheart/cobbleride/common/pokemon/RideableSpecies;", "", "name", "getByName", "(Ljava/lang/String;)Lnet/starliteheart/cobbleride/common/pokemon/RideableSpecies;", "", "data", "", "reload", "(Ljava/util/Map;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "resourcePath", "Ljava/lang/String;", "getResourcePath", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "speciesByIdentifier", "Ljava/util/HashMap;", "", "getSpecies", "()Ljava/util/Collection;", "species", "cobbleride-common"})
@SourceDebugExtension(value={"SMAP\nRideablePokemonSpecies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RideablePokemonSpecies.kt\nnet/starliteheart/cobbleride/common/api/pokemon/RideablePokemonSpecies\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n216#2,2:64\n1863#3,2:66\n*S KotlinDebug\n*F\n+ 1 RideablePokemonSpecies.kt\nnet/starliteheart/cobbleride/common/api/pokemon/RideablePokemonSpecies\n*L\n51#1:64,2\n41#1:66,2\n*E\n"})
public final class RideablePokemonSpecies
implements JsonDataRegistry<RideableSpecies> {
    @NotNull
    public static final RideablePokemonSpecies INSTANCE = new RideablePokemonSpecies();
    @NotNull
    private static final ResourceLocation id = CobbleRideUtilsKt.rideableResource("rideable_species");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final TypeToken<RideableSpecies> typeToken;
    @NotNull
    private static final String resourcePath;
    @NotNull
    private static final SimpleObservable<RideablePokemonSpecies> observable;
    @NotNull
    private static final HashMap<ResourceLocation, RideableSpecies> speciesByIdentifier;

    private RideablePokemonSpecies() {
    }

    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @NotNull
    public PackType getType() {
        return type;
    }

    @NotNull
    public Gson getGson() {
        return gson;
    }

    @NotNull
    public TypeToken<RideableSpecies> getTypeToken() {
        return typeToken;
    }

    @NotNull
    public String getResourcePath() {
        return resourcePath;
    }

    @NotNull
    public SimpleObservable<RideablePokemonSpecies> getObservable() {
        return observable;
    }

    private final Collection<RideableSpecies> getSpecies() {
        Collection<RideableSpecies> collection = speciesByIdentifier.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @Nullable
    public final RideableSpecies getByIdentifier(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return speciesByIdentifier.get(identifier);
    }

    @Nullable
    public final RideableSpecies getByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getByIdentifier(CobbleRideUtilsKt.rideableResource(name));
    }

    public void reload(@NotNull Map<ResourceLocation, RideableSpecies> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        speciesByIdentifier.clear();
        Map<ResourceLocation, RideableSpecies> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, RideableSpecies>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, RideableSpecies> element$iv;
            Map.Entry<ResourceLocation, RideableSpecies> entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation identifier = entry.getKey();
            RideableSpecies species = entry.getValue();
            species.setIdentifier(identifier);
            ((Map)speciesByIdentifier).put(identifier, species);
        }
        CobbleRideMod.INSTANCE.getLOGGER().info("Loaded {} Pok\u00e9mon species with ride details", (Object)this.getSpecies().size());
        Object[] objectArray = new RideablePokemonSpecies[]{this};
        this.getObservable().emit(objectArray);
    }

    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new RideableSpeciesRegistrySyncPacket(CollectionsKt.toList((Iterable)this.getSpecies())).sendToPlayer(player);
    }

    public void reload(@NotNull ResourceManager manager) {
        JsonDataRegistry.DefaultImpls.reload((JsonDataRegistry)this, (ResourceManager)manager);
    }

    private static final Unit _init_$lambda$0(PokemonSpecies it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = INSTANCE.getSpecies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RideableSpecies p0 = (RideableSpecies)element$iv;
            boolean bl = false;
            boolean $i$f$lambda$0$stub_for_inlining = false;
            p0.initialize();
        }
        return Unit.INSTANCE;
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Vec3.class), (Object)VerboseVec3dAdapter.INSTANCE).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        RideablePokemonSpecies.gson = gson;
        TypeToken typeToken = TypeToken.get(RideableSpecies.class);
        Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"get(...)");
        RideablePokemonSpecies.typeToken = typeToken;
        resourcePath = "rideable_species";
        observable = new SimpleObservable();
        speciesByIdentifier = new HashMap();
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)PokemonSpecies.INSTANCE.getObservable()), null, RideablePokemonSpecies::_init_$lambda$0, (int)1, null);
    }
}

