/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common.client;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelGUI;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.cobblemon.mod.common.client.gui.interact.wheel.Orientation;
import com.cobblemon.mod.common.client.gui.pokedex.ScaledButton;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.starliteheart.cobbleride.common.client.settings.Settings;
import net.starliteheart.cobbleride.common.debug.PokemonDebugHandler;
import net.starliteheart.cobbleride.common.entity.pokemon.RideablePokemonEntity;
import net.starliteheart.cobbleride.common.net.messages.server.pokemon.interact.MountPokemonPacket;
import net.starliteheart.cobbleride.common.net.messages.server.pokemon.update.DismountPokemonPacket;
import net.starliteheart.cobbleride.common.util.CobbleRideUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aE\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r\u001a%\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a5\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0015\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/resources/ResourceLocation;", "texture", "", "x", "y", "width", "height", "", "scale", "", "blitRideIcon", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;F)V", "resource", "Lcom/cobblemon/mod/common/client/gui/pokedex/ScaledButton;", "blipButton", "(Lnet/minecraft/resources/ResourceLocation;FF)Lcom/cobblemon/mod/common/client/gui/pokedex/ScaledButton;", "mouseX", "mouseY", "", "buttonSize", "", "isHovered", "(FFFFI)Z", "Lnet/minecraft/client/player/LocalPlayer;", "player", "attemptDismount", "(Lnet/minecraft/client/player/LocalPlayer;)Z", "Ljava/util/UUID;", "pokemonID", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI;", "createUnownedPokemonInteractGui", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI;", "cobbleride-common"})
public final class CobbleRideClientUtilsKt {
    public static final void blitRideIcon(@NotNull PoseStack matrices, @NotNull ResourceLocation texture, @NotNull Number x, @NotNull Number y, @NotNull Number width, @NotNull Number height, float scale) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)width, (String)"width");
        Intrinsics.checkNotNullParameter((Object)height, (String)"height");
        GuiUtilsKt.blitk$default((PoseStack)matrices, (ResourceLocation)texture, (Number)x, (Number)y, (Number)height, (Number)width, null, null, null, null, null, null, null, null, null, (boolean)false, (float)scale, (int)65472, null);
    }

    @NotNull
    public static final ScaledButton blipButton(@NotNull ResourceLocation resource, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return new ScaledButton(x, y, (Number)8, (Number)8, resource, 0.5f, true, CobbleRideClientUtilsKt::blipButton$lambda$0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isHovered(float mouseX, float mouseY, float x, float y, int buttonSize) {
        float xMin = x;
        float xMax = xMin + (float)buttonSize;
        float yMin = y;
        float yMax = yMin + (float)buttonSize;
        if (!(xMin <= mouseX)) return false;
        if (!(mouseX <= xMax)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!(yMin <= mouseY)) return false;
        if (!(mouseY <= yMax)) return false;
        return true;
    }

    public static final boolean attemptDismount(@NotNull LocalPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.getVehicle() instanceof RideablePokemonEntity) {
            Entity entity = player.getVehicle();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.starliteheart.cobbleride.common.entity.pokemon.RideablePokemonEntity");
            RideablePokemonEntity mount = (RideablePokemonEntity)entity;
            if (mount.canDismount()) {
                new DismountPokemonPacket().sendToServer();
                if (Settings.Client.INSTANCE.getUseFirstPersonAfterDismount()) {
                    Minecraft.getInstance().options.setCameraType(CameraType.FIRST_PERSON);
                }
                if (Settings.Client.INSTANCE.getUseDebugKeys()) {
                    PokemonDebugHandler pokemonDebugHandler = mount.getDebug();
                    Intrinsics.checkNotNull((Object)pokemonDebugHandler);
                    pokemonDebugHandler.reset();
                }
                return true;
            }
            if (!Settings.Server.INSTANCE.getCommon().getCanDismountInMidair()) {
                player.displayClientMessage((Component)Component.translatable((String)"cobbleride.message.system.dismount.too_high"), true);
            }
        }
        return false;
    }

    @NotNull
    public static final InteractWheelGUI createUnownedPokemonInteractGui(@NotNull UUID pokemonID) {
        Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
        InteractWheelOption mountPokemon = new InteractWheelOption(CobbleRideUtilsKt.rideableResource("textures/gui/interact/ride-cyclizar-ride.png"), null, "cobbleride.ui.interact.ride.mount", null, () -> CobbleRideClientUtilsKt.createUnownedPokemonInteractGui$lambda$1(pokemonID), 10, null);
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
        Multimap options = (Multimap)arrayListMultimap;
        options.put((Object)Orientation.BOTTOM_LEFT, (Object)mountPokemon);
        MutableComponent mutableComponent = Component.translatable((String)"cobbleride.ui.interact.pokemon.unowned");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return new InteractWheelGUI(options, (Component)mutableComponent);
    }

    private static final void blipButton$lambda$0(Button it) {
    }

    private static final Unit createUnownedPokemonInteractGui$lambda$1(UUID $pokemonID) {
        new MountPokemonPacket($pokemonID, true).sendToServer();
        Minecraft.getInstance().setScreen(null);
        return Unit.INSTANCE;
    }
}

