/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common.entity.pokemon;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.entity.PlatformType;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.starliteheart.cobbleride.common.api.pokemon.RideablePokemonSpecies;
import net.starliteheart.cobbleride.common.client.settings.Settings;
import net.starliteheart.cobbleride.common.config.ConfigConstants;
import net.starliteheart.cobbleride.common.debug.PokemonDebugHandler;
import net.starliteheart.cobbleride.common.mixin.accessor.LivingEntityAccessor;
import net.starliteheart.cobbleride.common.net.messages.client.pokemon.ai.ClientMoveBehaviour;
import net.starliteheart.cobbleride.common.net.messages.client.spawn.SpawnRidePokemonPacket;
import net.starliteheart.cobbleride.common.net.messages.server.pokemon.update.SetRidePokemonExhaustPacket;
import net.starliteheart.cobbleride.common.pokemon.RideableFormData;
import net.starliteheart.cobbleride.common.pokemon.RideableSpecies;
import net.starliteheart.cobbleride.common.pokemon.RiderOffsetType;
import net.starliteheart.cobbleride.common.pokemon.Seat;
import net.starliteheart.cobbleride.common.util.CobbleRideUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\rJ\u0015\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b \u0010\rJ\u000f\u0010!\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b!\u0010\rJ\u000f\u0010\"\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\"\u0010\rJ\u0017\u0010%\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b'\u0010\rJ\u0017\u0010*\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b,\u0010\rJ\u000f\u0010-\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b-\u0010\rJ\u000f\u0010.\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b.\u0010\rJ\u0017\u00101\u001a\u00020\u000b2\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b1\u00102J\u0015\u00104\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b4\u00105J\u0015\u00108\u001a\u0002072\u0006\u00106\u001a\u000203\u00a2\u0006\u0004\b8\u00109J\u0015\u0010;\u001a\u00020:2\u0006\u00106\u001a\u000203\u00a2\u0006\u0004\b;\u0010<J'\u0010A\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?H\u0014\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010C\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020#H\u0016\u00a2\u0006\u0004\bC\u0010DJ!\u0010F\u001a\u0004\u0018\u00010:2\u0006\u0010E\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020#H\u0002\u00a2\u0006\u0004\bF\u0010GJ\r\u0010H\u001a\u00020\u000b\u00a2\u0006\u0004\bH\u0010\rJ\u0011\u0010I\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0004\bI\u0010JJ\u0017\u0010K\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020#H\u0002\u00a2\u0006\u0004\bK\u0010&J'\u0010P\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020?2\u0006\u0010M\u001a\u00020?2\u0006\u0010O\u001a\u00020NH\u0016\u00a2\u0006\u0004\bP\u0010QJ\r\u0010R\u001a\u00020\u000b\u00a2\u0006\u0004\bR\u0010\rJ\u001f\u0010U\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020SH\u0014\u00a2\u0006\u0004\bU\u0010VJ\u001f\u0010W\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010E\u001a\u00020:H\u0014\u00a2\u0006\u0004\bW\u0010XJ\u000f\u0010Y\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\bY\u0010\u0016J\u0017\u0010[\u001a\u00020Z2\u0006\u0010\u001d\u001a\u00020#H\u0002\u00a2\u0006\u0004\b[\u0010\\J\u001f\u0010^\u001a\u00020:2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010]\u001a\u00020:H\u0014\u00a2\u0006\u0004\b^\u0010_J\u0017\u0010`\u001a\u00020?2\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b`\u0010aJ'\u0010e\u001a\u00020:2\u0006\u0010c\u001a\u00020b2\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020:H\u0016\u00a2\u0006\u0004\be\u0010fJ\u001d\u0010k\u001a\b\u0012\u0004\u0012\u00020j0i2\u0006\u0010h\u001a\u00020gH\u0016\u00a2\u0006\u0004\bk\u0010lR\u0016\u0010p\u001a\u0004\u0018\u00010m8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bn\u0010oR\u0011\u0010s\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bq\u0010rR\"\u0010u\u001a\u00020t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bu\u0010v\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\u0014\u0010~\u001a\u00020{8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b|\u0010}R%\u0010\u0080\u0001\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020:0\u007f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0019\u0010\u0082\u0001\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0019\u0010\u0084\u0001\u001a\u00020?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0084\u0001\u0010\u0085\u0001R)\u0010\u0086\u0001\u001a\u00020?8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0086\u0001\u0010\u0085\u0001\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R\u0013\u0010\u008c\u0001\u001a\u00020\u000b8F\u00a2\u0006\u0007\u001a\u0005\b\u008b\u0001\u0010\rR\u0013\u0010\u008e\u0001\u001a\u00020\u000b8F\u00a2\u0006\u0007\u001a\u0005\b\u008d\u0001\u0010\rR1\u0010\u0090\u0001\u001a\u00020\u000b2\u0007\u0010\u008f\u0001\u001a\u00020\u000b8\u0006@FX\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u0090\u0001\u0010\u0083\u0001\u001a\u0005\b\u0090\u0001\u0010\r\"\u0006\b\u0091\u0001\u0010\u0092\u0001R\u0013\u0010\u0093\u0001\u001a\u00020\u000b8F\u00a2\u0006\u0007\u001a\u0005\b\u0093\u0001\u0010\rR(\u0010\u0094\u0001\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u0094\u0001\u0010\u0083\u0001\u001a\u0005\b\u0094\u0001\u0010\r\"\u0006\b\u0095\u0001\u0010\u0092\u0001R(\u0010\u0096\u0001\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u0096\u0001\u0010\u0083\u0001\u001a\u0005\b\u0096\u0001\u0010\r\"\u0006\b\u0097\u0001\u0010\u0092\u0001R\u0013\u0010\u0098\u0001\u001a\u00020\u000b8F\u00a2\u0006\u0007\u001a\u0005\b\u0098\u0001\u0010\rR\u001f\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0099\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u009a\u0001\u0010\u009b\u0001\u001a\u0006\b\u009c\u0001\u0010\u009d\u0001\u00a8\u0006\u009e\u0001"}, d2={"Lnet/starliteheart/cobbleride/common/entity/pokemon/RideablePokemonEntity;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lnet/minecraft/world/entity/PlayerRideable;", "Lnet/minecraft/world/entity/Saddleable;", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/level/Level;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "(Lnet/minecraft/world/level/Level;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "isSaddleable", "()Z", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "Lnet/minecraft/sounds/SoundSource;", "soundSource", "", "equipSaddle", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/sounds/SoundSource;)V", "removeSaddle", "()V", "isSaddled", "Lnet/minecraft/world/entity/player/Player;", "player", "canBeRiddenBy", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/world/entity/Entity;", "entity", "canAddPassenger", "(Lnet/minecraft/world/entity/Entity;)Z", "isAllowedDimension", "isPushable", "isImmobile", "Lnet/minecraft/world/entity/LivingEntity;", "livingEntity", "isOwnedBy", "(Lnet/minecraft/world/entity/LivingEntity;)Z", "canSitOnShoulder", "Lnet/minecraft/world/level/material/FluidState;", "state", "canStandOnFluid", "(Lnet/minecraft/world/level/material/FluidState;)Z", "isOnWaterSurface", "isAbleToDive", "isAbleToFly", "Lcom/cobblemon/mod/common/entity/PoseType;", "poseType", "isInPoseOfType", "(Lcom/cobblemon/mod/common/entity/PoseType;)Z", "", "getPassengerIndex", "(Lnet/minecraft/world/entity/Entity;)I", "index", "Lnet/starliteheart/cobbleride/common/pokemon/Seat;", "getOffsets", "(I)Lnet/starliteheart/cobbleride/common/pokemon/Seat;", "Lnet/minecraft/world/phys/Vec3;", "getOffset", "(I)Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/world/entity/EntityDimensions;", "dimensions", "", "f", "getPassengerAttachmentPoint", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/EntityDimensions;F)Lnet/minecraft/world/phys/Vec3;", "getDismountLocationForPassenger", "(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;", "vec3", "getDismountLocationInDirection", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;", "canDismount", "getControllingPassenger", "()Lnet/minecraft/world/entity/LivingEntity;", "canBeControlledBy", "fallDistance", "damageMultiplier", "Lnet/minecraft/world/damagesource/DamageSource;", "damageSource", "causeFallDamage", "(FFLnet/minecraft/world/damagesource/DamageSource;)Z", "shouldRiderSit", "Lnet/minecraft/world/entity/Entity$MoveFunction;", "moveFunction", "positionRider", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V", "tickRidden", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V", "tick", "Lnet/minecraft/world/phys/Vec2;", "getRiddenRotation", "(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec2;", "v", "getRiddenInput", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "getRiddenSpeed", "(Lnet/minecraft/world/entity/player/Player;)F", "", "d", "bl", "getFluidFallingAdjustedMovement", "(DZLnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/server/level/ServerEntity;", "entityTrackerEntry", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getAddEntityPacket", "(Lnet/minecraft/server/level/ServerEntity;)Lnet/minecraft/network/protocol/Packet;", "Lnet/starliteheart/cobbleride/common/pokemon/RideableFormData;", "getRideData", "()Lnet/starliteheart/cobbleride/common/pokemon/RideableFormData;", "rideData", "getSeatCount", "()I", "seatCount", "Lnet/starliteheart/cobbleride/common/net/messages/client/pokemon/ai/ClientMoveBehaviour;", "moveBehaviour", "Lnet/starliteheart/cobbleride/common/net/messages/client/pokemon/ai/ClientMoveBehaviour;", "getMoveBehaviour", "()Lnet/starliteheart/cobbleride/common/net/messages/client/pokemon/ai/ClientMoveBehaviour;", "setMoveBehaviour", "(Lnet/starliteheart/cobbleride/common/net/messages/client/pokemon/ai/ClientMoveBehaviour;)V", "Lnet/starliteheart/cobbleride/common/client/settings/Settings$Server;", "getServerSettings", "()Lnet/starliteheart/cobbleride/common/client/settings/Settings$Server;", "serverSettings", "", "lastRiderPosition", "Ljava/util/Map;", "shouldSinkInWater", "Z", "sprintCooldownScale", "F", "sprintStaminaScale", "getSprintStaminaScale", "()F", "setSprintStaminaScale", "(F)V", "getCanSprint", "canSprint", "getCanExhaust", "canExhaust", "value", "isExhausted", "setExhausted", "(Z)V", "isRideAscending", "isRideDescending", "setRideDescending", "isRideSprinting", "setRideSprinting", "isRideable", "Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler;", "debug", "Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler;", "getDebug", "()Lnet/starliteheart/cobbleride/common/debug/PokemonDebugHandler;", "cobbleride-common"})
@SourceDebugExtension(value={"SMAP\nRideablePokemonEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RideablePokemonEntity.kt\nnet/starliteheart/cobbleride/common/entity/pokemon/RideablePokemonEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,572:1\n1#2:573\n1755#3,3:574\n*S KotlinDebug\n*F\n+ 1 RideablePokemonEntity.kt\nnet/starliteheart/cobbleride/common/entity/pokemon/RideablePokemonEntity\n*L\n194#1:574,3\n*E\n"})
public final class RideablePokemonEntity
extends PokemonEntity
implements PlayerRideable,
Saddleable {
    @NotNull
    private ClientMoveBehaviour moveBehaviour;
    @NotNull
    private Map<Integer, Vec3> lastRiderPosition;
    private boolean shouldSinkInWater;
    private float sprintCooldownScale;
    private float sprintStaminaScale;
    private boolean isExhausted;
    private boolean isRideDescending;
    private boolean isRideSprinting;
    @Nullable
    private final PokemonDebugHandler debug;

    public RideablePokemonEntity(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world, null, null, 6, null);
        this.moveBehaviour = new ClientMoveBehaviour(this.getExposedForm().getBehaviour().getMoving());
        this.lastRiderPosition = new LinkedHashMap();
        this.debug = Settings.Client.INSTANCE.getUseDebugKeys() ? new PokemonDebugHandler(this) : null;
    }

    public RideablePokemonEntity(@NotNull Level world, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        super(world, pokemon, null, 4, null);
        this.moveBehaviour = new ClientMoveBehaviour(this.getExposedForm().getBehaviour().getMoving());
        this.lastRiderPosition = new LinkedHashMap();
        this.debug = Settings.Client.INSTANCE.getUseDebugKeys() ? new PokemonDebugHandler(this) : null;
    }

    private final RideableFormData getRideData() {
        RideableSpecies rideableSpecies = RideablePokemonSpecies.INSTANCE.getByName(this.getExposedSpecies().showdownId());
        return rideableSpecies != null ? rideableSpecies.getForm(this.getExposedForm().getName()) : null;
    }

    public final int getSeatCount() {
        int n;
        if (this.isRideable()) {
            RideableFormData rideableFormData = this.getRideData();
            Intrinsics.checkNotNull((Object)rideableFormData);
            if (!((Collection)rideableFormData.getAdditionalSeats()).isEmpty()) {
                RideableFormData rideableFormData2 = this.getRideData();
                Intrinsics.checkNotNull((Object)rideableFormData2);
                n = rideableFormData2.getAdditionalSeats().size() + 1;
            } else {
                n = 1;
            }
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final ClientMoveBehaviour getMoveBehaviour() {
        return this.moveBehaviour;
    }

    public final void setMoveBehaviour(@NotNull ClientMoveBehaviour clientMoveBehaviour) {
        Intrinsics.checkNotNullParameter((Object)clientMoveBehaviour, (String)"<set-?>");
        this.moveBehaviour = clientMoveBehaviour;
    }

    private final Settings.Server getServerSettings() {
        return Settings.Server.INSTANCE;
    }

    public final float getSprintStaminaScale() {
        return this.sprintStaminaScale;
    }

    public final void setSprintStaminaScale(float f) {
        this.sprintStaminaScale = f;
    }

    public final boolean getCanSprint() {
        return this.getServerSettings().getSprinting().getCanSprint();
    }

    public final boolean getCanExhaust() {
        return this.getServerSettings().getSprinting().getCanExhaust();
    }

    public final boolean isExhausted() {
        return this.isExhausted;
    }

    public final void setExhausted(boolean value) {
        if (this.isExhausted != value) {
            this.isExhausted = value;
            if (this.level().isClientSide) {
                new SetRidePokemonExhaustPacket(this.getId(), value).sendToServer();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isRideAscending() {
        if (this.getControllingPassenger() == null) return false;
        LivingEntity livingEntity = this.getControllingPassenger();
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.starliteheart.cobbleride.common.mixin.accessor.LivingEntityAccessor");
        if (!((LivingEntityAccessor)livingEntity).getJumping()) return false;
        return true;
    }

    public final boolean isRideDescending() {
        return this.isRideDescending;
    }

    public final void setRideDescending(boolean bl) {
        this.isRideDescending = bl;
    }

    public final boolean isRideSprinting() {
        return this.isRideSprinting;
    }

    public final void setRideSprinting(boolean bl) {
        this.isRideSprinting = bl;
    }

    public boolean isSaddleable() {
        return this.isAlive() && this.getServerSettings().getRestrictions().isSaddleRequired();
    }

    public void equipSaddle(@NotNull ItemStack itemStack, @Nullable SoundSource soundSource) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Pokemon pokemon = this.getPokemon();
        pokemon.setForcedAspects(SetsKt.plus((Set)pokemon.getForcedAspects(), (Object)"saddled"));
        this.playSound(SoundEvents.HORSE_SADDLE, 0.5f, 1.0f);
    }

    public final void removeSaddle() {
        Pokemon pokemon = this.getPokemon();
        pokemon.setForcedAspects(SetsKt.minus((Set)pokemon.getForcedAspects(), (Object)"saddled"));
    }

    public boolean isSaddled() {
        return this.getPokemon().getAspects().contains("saddled");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isRideable() {
        if (this.getRideData() == null) return false;
        RideableFormData rideableFormData = this.getRideData();
        Intrinsics.checkNotNull((Object)rideableFormData);
        if (!rideableFormData.getEnabled()) return false;
        return true;
    }

    public final boolean canBeRiddenBy(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.isRideable() && (this.canBeControlledBy((LivingEntity)player) || !this.isBattling()) && !this.isEvolving() && !(this.getOwner() instanceof NPCEntity) && this.isAllowedDimension();
    }

    public boolean canAddPassenger(@NotNull Entity entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.getPassengers().size() < 1 + ((object = this.getRideData()) != null && (object = ((RideableFormData)object).getAdditionalSeats()) != null ? object.size() : 0);
    }

    private final boolean isAllowedDimension() {
        return !this.getServerSettings().getRestrictions().getBlacklistedDimensions().contains(this.level().dimension().location().toString());
    }

    public boolean isPushable() {
        return !this.isVehicle() && super.isPushable();
    }

    protected boolean isImmobile() {
        PersistentStatusContainer persistentStatusContainer = this.getPokemon().getStatus();
        return Intrinsics.areEqual((Object)(persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null), (Object)Statuses.INSTANCE.getSLEEP()) || super.isImmobile();
    }

    public boolean isOwnedBy(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        return Intrinsics.areEqual((Object)this.getOwnerUUID(), (Object)livingEntity.getUUID());
    }

    public boolean canSitOnShoulder() {
        return this.getPassengers().isEmpty() && super.canSitOnShoulder();
    }

    public boolean canStandOnFluid(@NotNull FluidState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !this.shouldSinkInWater && (state.is(FluidTags.WATER) && !this.isEyeInFluid(FluidTags.WATER) ? this.moveBehaviour.getSwim().getCanWalkOnWater() : (state.is(FluidTags.LAVA) && !this.isEyeInFluid(FluidTags.LAVA) ? this.moveBehaviour.getSwim().getCanWalkOnLava() : false));
    }

    private final boolean isOnWaterSurface() {
        return this.isInWater() && !this.isUnderWater();
    }

    private final boolean isAbleToDive() {
        return this.moveBehaviour.getSwim().getCanSwimInWater() && this.moveBehaviour.getSwim().getCanBreatheUnderwater();
    }

    private final boolean isAbleToFly() {
        return this.moveBehaviour.getFly().getCanFly();
    }

    private final boolean isInPoseOfType(PoseType poseType) {
        return this.getCurrentPoseType() == poseType;
    }

    @Nullable
    public final PokemonDebugHandler getDebug() {
        return this.debug;
    }

    public final int getPassengerIndex(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int index = this.getPassengers().indexOf(entity);
        if (this.debug != null && this.level().isClientSide) {
            index += this.debug.getIndexOffset();
        }
        return index;
    }

    @NotNull
    public final Seat getOffsets(int index) {
        Object[] objectArray = new Seat[1];
        RideableFormData rideableFormData = this.getRideData();
        objectArray[0] = rideableFormData != null ? rideableFormData.getOffsets() : null;
        List seats = CollectionsKt.mutableListOf((Object[])objectArray);
        Object object = this.getRideData();
        seats.addAll(object != null && (object = ((RideableFormData)object).getAdditionalSeats()) != null && (object = CollectionsKt.toList((Iterable)((Iterable)object))) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
        Seat seat = (Seat)seats.get(index);
        if (seat == null) {
            seat = new Seat();
        }
        return seat;
    }

    @NotNull
    public final Vec3 getOffset(int index) {
        boolean bl;
        Object it;
        Vec3 offset;
        Seat offsets;
        block26: {
            offsets = this.getOffsets(index);
            offset = null;
            Vec3 vec3 = (Vec3)offsets.get((Object)RiderOffsetType.DEFAULT);
            if (vec3 == null) {
                vec3 = offset = Vec3.ZERO;
            }
            if (this.isFlying() && this.isInPoseOfType(PoseType.HOVER) && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.HOVERING)) {
                Vec3 vec32 = (Vec3)offsets.get((Object)RiderOffsetType.HOVERING);
                if (vec32 != null) {
                    it = vec32;
                    boolean bl2 = false;
                    offset = offset.add((Vec3)it);
                }
            } else if (this.isFlying() && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.FLYING)) {
                Vec3 vec33 = (Vec3)offsets.get((Object)RiderOffsetType.FLYING);
                if (vec33 != null) {
                    it = vec33;
                    boolean bl3 = false;
                    offset = offset.add((Vec3)it);
                }
            } else if (this.isUnderWater() && this.isInPoseOfType(PoseType.FLOAT) && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.SUSPENDED)) {
                Vec3 vec34 = (Vec3)offsets.get((Object)RiderOffsetType.SUSPENDED);
                if (vec34 != null) {
                    it = vec34;
                    boolean bl4 = false;
                    offset = offset.add((Vec3)it);
                }
            } else if (this.isUnderWater() && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.DIVING)) {
                Vec3 vec35 = (Vec3)offsets.get((Object)RiderOffsetType.DIVING);
                if (vec35 != null) {
                    it = vec35;
                    boolean bl5 = false;
                    offset = offset.add((Vec3)it);
                }
            } else if (this.isOnWaterSurface() && this.isInPoseOfType(PoseType.STAND) && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.FLOATING)) {
                Vec3 vec36 = (Vec3)offsets.get((Object)RiderOffsetType.FLOATING);
                if (vec36 != null) {
                    it = vec36;
                    boolean bl6 = false;
                    offset = offset.add((Vec3)it);
                }
            } else if (this.isOnWaterSurface() && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.SWIMMING)) {
                Vec3 vec37 = (Vec3)offsets.get((Object)RiderOffsetType.SWIMMING);
                if (vec37 != null) {
                    it = vec37;
                    boolean bl7 = false;
                    offset = offset.add((Vec3)it);
                }
            } else if (this.isInPoseOfType(PoseType.WALK) && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.WALKING)) {
                Vec3 vec38 = (Vec3)offsets.get((Object)RiderOffsetType.WALKING);
                if (vec38 != null) {
                    it = vec38;
                    boolean bl8 = false;
                    offset = offset.add((Vec3)it);
                }
            }
            Iterable $this$any$iv = this.getAspects();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl9 = false;
                    if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)"sheared", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block26;
                }
                bl = false;
            }
        }
        if (bl && RideablePokemonEntity.getOffset$hasOffset(offsets, RiderOffsetType.SHEARED)) {
            Vec3 vec3 = (Vec3)offsets.get((Object)RiderOffsetType.SHEARED);
            if (vec3 != null) {
                it = vec3;
                boolean bl10 = false;
                offset = offset.add((Vec3)it);
            }
        }
        Vec3 vec3 = offset;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"element");
        return vec3;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(@NotNull Entity entity, @NotNull EntityDimensions dimensions, float f) {
        Vec3 lastPos;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        int index = this.getPassengerIndex(entity);
        if (index < 0) {
            Vec3 vec3 = super.getPassengerAttachmentPoint(entity, dimensions, f);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPassengerAttachmentPoint(...)");
            return vec3;
        }
        Vec3 offset = this.getOffset(index);
        Vec3 attachmentPoint = super.getPassengerAttachmentPoint(entity, dimensions, f).add(offset);
        if (this.debug != null && this.level().isClientSide) {
            attachmentPoint = attachmentPoint.add(this.debug.getVectorOffset());
        }
        if ((lastPos = this.lastRiderPosition.get(index)) != null && lastPos.distanceTo(attachmentPoint) > 0.05) {
            attachmentPoint = attachmentPoint.multiply(0.2, 0.2, 0.2).add(lastPos.multiply(0.8, 0.8, 0.8));
        }
        Integer n = index;
        this.lastRiderPosition.put(n, attachmentPoint);
        Vec3 vec3 = attachmentPoint.yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"yRot(...)");
        return vec3;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 vec3 = ShoulderRidingEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)entity.getBbWidth(), (float)(this.getYRot() + (entity.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Intrinsics.checkNotNull((Object)vec3);
        Vec3 vec32 = this.getDismountLocationInDirection(vec3, entity);
        if (vec32 != null) {
            return vec32;
        }
        Vec3 vec33 = ShoulderRidingEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)entity.getBbWidth(), (float)(this.getYRot() + (entity.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Intrinsics.checkNotNull((Object)vec33);
        Vec3 vec34 = this.getDismountLocationInDirection(vec33, entity);
        Vec3 vec35 = vec34;
        if (vec35 == null) {
            Vec3 vec36 = this.position();
            vec35 = vec36;
            Intrinsics.checkNotNullExpressionValue((Object)vec36, (String)"position(...)");
        }
        return vec35;
    }

    private final Vec3 getDismountLocationInDirection(Vec3 vec3, LivingEntity entity) {
        double d = this.getX() + vec3.x;
        double e = this.getBoundingBox().minY - 2.0;
        double f = this.getZ() + vec3.z;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        UnmodifiableIterator unmodifiableIterator = entity.getDismountPoses().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        block0: while (unmodifiableIterator2.hasNext()) {
            Pose pose = (Pose)unmodifiableIterator2.next();
            mutableBlockPos.set(d, e, f);
            double g = this.getBoundingBox().maxY + 0.75;
            do {
                double h = this.level().getBlockFloorHeight((BlockPos)mutableBlockPos);
                if ((double)mutableBlockPos.getY() + h > g) continue block0;
                if (DismountHelper.isBlockFloorValid((double)h)) {
                    AABB aABB = entity.getLocalBoundsForPose(pose);
                    Vec3 vec32 = new Vec3(d, (double)mutableBlockPos.getY() + h, f);
                    if (DismountHelper.canDismountTo((CollisionGetter)((CollisionGetter)this.level()), (LivingEntity)entity, (AABB)aABB.move(vec32))) {
                        entity.setPose(pose);
                        return vec32;
                    }
                }
                mutableBlockPos.move(Direction.UP);
            } while ((double)mutableBlockPos.getY() < g);
        }
        return null;
    }

    public final boolean canDismount() {
        return !this.isFlying() || Settings.Server.INSTANCE.getCommon().getCanDismountInMidair() || CobbleRideUtilsKt.getDistanceToGround((Entity)this) < 2.0;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        return entity instanceof LivingEntity && this.canBeControlledBy((LivingEntity)entity) ? (LivingEntity)entity : super.getControllingPassenger();
    }

    private final boolean canBeControlledBy(LivingEntity entity) {
        return entity instanceof Player && this.isOwnedBy(entity);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        boolean flag = super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
        if (flag && this.isVehicle()) {
            int i = this.calculateFallDamage(fallDistance, damageMultiplier);
            for (Object t : this.getIndirectPassengers()) {
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type net.minecraft.world.entity.Entity");
                Entity entity = (Entity)t;
                entity.hurt(damageSource, (float)i);
            }
        }
        return flag;
    }

    public final boolean shouldRiderSit() {
        RideableFormData rideableFormData = this.getRideData();
        return rideableFormData != null ? rideableFormData.getShouldRiderSit() : true;
    }

    protected void positionRider(@NotNull Entity entity, @NotNull Entity.MoveFunction moveFunction) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)moveFunction, (String)"moveFunction");
        super.positionRider(entity, moveFunction);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).yBodyRot = this.yBodyRot;
        }
    }

    protected void tickRidden(@NotNull Player player, @NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"vec3");
        super.tickRidden(player, vec3);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.setRot(CobbleRideUtilsKt.rotLerp(vec2.y, this.yRotO), CobbleRideUtilsKt.lerp(vec2.x, this.xRotO));
        this.yHeadRot = vec2.y;
        this.yBodyRot = CobbleRideUtilsKt.rotLerp(this.yHeadRot, this.yRotO);
        this.yRotO = CobbleRideUtilsKt.rotLerp(this.yBodyRot, this.yRotO);
        if (!this.shouldRiderSit()) {
            player.yBodyRot = this.yBodyRot;
            player.yRotO = this.yRotO;
            player.calculateEntityAnimation(false);
        }
        if (this.moveBehaviour.getSwim().getCanBreatheUnderwater() && this.getServerSettings().getGeneral().isWaterBreathingShared()) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 60, 0, false, false, false));
        }
        if (this.isControlledByLocalInstance()) {
            boolean shouldBeSprinting;
            if ((this.isInLava() && !this.moveBehaviour.getSwim().getCanBreatheUnderlava() || (this.moveBehaviour.getSwim().getCanSwimInWater() && !this.moveBehaviour.getSwim().getCanBreatheUnderwater() || this.isAbleToDive() && this.isOnWaterSurface() && !this.isRideDescending) && this.isInWater() && this.getFluidHeight(FluidTags.WATER) > this.getFluidJumpThreshold()) && this.random.nextFloat() < 0.8f) {
                this.jumpControl.jump();
            }
            this.shouldSinkInWater = this.isAbleToDive() && (this.isRideDescending || this.isOnWaterSurface() && this.getFluidHeight(FluidTags.WATER) > this.getFluidJumpThreshold());
            boolean bl = shouldBeSprinting = !(!this.getCanSprint() || !this.isInWater() && !this.isFlying() && !this.getServerSettings().getSprinting().getCanSprintOnLand() || this.isInWater() && !this.getServerSettings().getSprinting().getCanSprintInWater() || this.isFlying() && !this.getServerSettings().getSprinting().getCanSprintInAir() || !this.isRideSprinting || !(vec3.horizontalDistance() > 0.0) || this.getCanExhaust() && (this.isExhausted || !(this.sprintStaminaScale > 0.0f)));
            if (shouldBeSprinting) {
                this.sprintCooldownScale = 0.0f;
                if (this.getCanExhaust()) {
                    this.sprintStaminaScale = Math.max(this.sprintStaminaScale - 1.0f / (float)this.getServerSettings().getSprinting().getMaxStamina(), 0.0f);
                    if (this.sprintStaminaScale == 0.0f) {
                        this.setExhausted(true);
                    }
                }
            }
            this.setSprinting(shouldBeSprinting);
            player.setSprinting(shouldBeSprinting);
        }
        if (this.isFlying() && (this.onGround() || this.isInWater()) && this.couldStopFlying()) {
            this.setBehaviourFlag(PokemonBehaviourFlag.FLYING, false);
        }
        if (this.isRideAscending()) {
            if (this.isAbleToFly() && !this.isFlying() && !EntityExtensionsKt.getIsSubmerged((Entity)((Entity)this))) {
                this.setBehaviourFlag(PokemonBehaviourFlag.FLYING, true);
            } else if (!this.isAbleToFly() && (this.onGround() || this.isInLiquid() && !this.isUnderWater())) {
                this.jumpControl.jump();
            }
        }
        this.jumpControl.tick();
    }

    public void tick() {
        super.tick();
        if (this.isBattling()) {
            this.setPlatform(this.getTicksLived() > 5 && this.getOwnerUUID() != null && this.isInWater() && !this.isUnderWater() && !this.getExposedForm().getBehaviour().getMoving().getSwim().getCanBreatheUnderwater() && !this.getExposedForm().getBehaviour().getMoving().getSwim().getCanWalkOnWater() && !this.isFlying() ? PlatformType.Companion.getPlatformTypeForPokemon(this.getExposedForm()) : PlatformType.NONE);
        } else {
            if (this.getBeamMode() == 0 && this.isBattleClone()) {
                this.discard();
                return;
            }
            this.setPlatform(PlatformType.NONE);
        }
        if (this.getCanSprint() && this.getCanExhaust()) {
            if (this.level().isClientSide) {
                if (!this.isSprinting() && this.sprintStaminaScale < 1.0f) {
                    if (this.getServerSettings().getSprinting().getRecoveryDelay() > 0 && this.sprintCooldownScale < 1.0f) {
                        this.sprintCooldownScale = Math.min(this.sprintCooldownScale + 1.0f / (float)this.getServerSettings().getSprinting().getRecoveryDelay(), 1.0f);
                    } else {
                        this.sprintStaminaScale = Math.min(this.sprintStaminaScale + 1.0f / (float)this.getServerSettings().getSprinting().getRecoveryTime(), 1.0f);
                    }
                }
                if (!this.isExhausted || !((double)this.sprintStaminaScale < this.getServerSettings().getSprinting().getExhaustionDuration())) {
                    this.setExhausted(false);
                }
            }
            if (this.isExhausted && this.tickCount % 4 == 0) {
                Entity entity = (Entity)this;
                SimpleParticleType simpleParticleType = ParticleTypes.FALLING_WATER;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"FALLING_WATER");
                CobbleRideUtilsKt.emitParticle(entity, simpleParticleType);
            }
        }
    }

    private final Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.getXRot() * 0.5f, entity.getYRot());
    }

    @NotNull
    protected Vec3 getRiddenInput(@NotNull Player player, @NotNull Vec3 v) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (this.isImmobile()) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        float xxa = player.xxa * 0.5f;
        float zza = player.zza;
        if (zza <= 0.0f) {
            zza *= 0.25f;
        }
        Vec3 vec3 = new Vec3((double)xxa, 0.0, (double)zza);
        if (Settings.Client.INSTANCE.getUseCameraNavigation() && vec3.length() > 0.0 && (this.isInWater() && this.isAbleToDive() && (EntityExtensionsKt.getIsSubmerged((Entity)((Entity)this)) || this.isRideDescending) || this.isInLava() || this.isFlying())) {
            vec3 = vec3.xRot(-AngleExtensionsKt.toRadians((Number)Float.valueOf(player.getXRot())));
        }
        if (this.isInWater() && this.isAbleToDive() || this.isInLava() || this.isFlying()) {
            float verticalSpeed = (float)(this.isFlying() ? this.getServerSettings().getGeneral().getAirVerticalClimbSpeed() : this.getServerSettings().getGeneral().getWaterVerticalClimbSpeed());
            if (this.isRideAscending() && !this.isRideDescending) {
                vec3 = vec3.add(0.0, (double)verticalSpeed, 0.0);
            } else if (this.isRideDescending && !this.isRideAscending()) {
                vec3 = vec3.add(0.0, -((double)verticalSpeed), 0.0);
            }
        }
        return vec3;
    }

    protected float getRiddenSpeed(@NotNull Player player) {
        double mediumModifier;
        double d;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.getServerSettings().getSpeedStat().getAffectsSpeed()) {
            int minSpeedStat = this.getServerSettings().getSpeedStat().getMinStatThreshold();
            int maxSpeedStat = this.getServerSettings().getSpeedStat().getMaxStatThreshold();
            double minSpeedModifier = this.getServerSettings().getSpeedStat().getMinSpeedModifier();
            double maxSpeedModifier = this.getServerSettings().getSpeedStat().getMaxSpeedModifier();
            Object v = this.getPokemon().getForm().getBaseStats().get(Stats.SPEED);
            Intrinsics.checkNotNull(v);
            int base = ((Number)v).intValue();
            int iv = this.getPokemon().getIvs().getOrDefault((Stat)Stats.SPEED);
            int ev = this.getPokemon().getEvs().getOrDefault((Stat)Stats.SPEED);
            int speed = switch (WhenMappings.$EnumSwitchMapping$0[this.getServerSettings().getSpeedStat().getSpeedSelection().ordinal()]) {
                case 1 -> base;
                case 2 -> this.getPokemon().getEffectiveNature().modifyStat((Stat)Stats.SPEED, base);
                case 3 -> this.getPokemon().getEffectiveNature().modifyStat((Stat)Stats.SPEED, 2 * base + iv + ev / 4 + 5);
                case 4 -> this.getPokemon().getSpeed();
                default -> throw new NoWhenBranchMatchedException();
            };
            double clampedSpeedStat = RangesKt.coerceIn((int)speed, (int)minSpeedStat, (int)maxSpeedStat);
            double scaledSpeedStat = (clampedSpeedStat - (double)minSpeedStat) / (double)(maxSpeedStat - minSpeedStat);
            d = minSpeedModifier + scaledSpeedStat * (maxSpeedModifier - minSpeedModifier);
        } else {
            d = 1.0;
        }
        double speedModifier = d;
        float mediumSpeed = 0.35f;
        if (this.isFlying()) {
            RideableFormData rideableFormData = this.getRideData();
            v4 = (double)(rideableFormData != null ? rideableFormData.getAirSpeedModifier() : 1.0f) * this.getServerSettings().getGeneral().getGlobalAirSpeedModifier() * (double)2.0f;
        } else if (this.isInWater() || this.isInLava()) {
            RideableFormData rideableFormData = this.getRideData();
            v4 = (double)(rideableFormData != null ? rideableFormData.getWaterSpeedModifier() : 1.0f) * this.getServerSettings().getGeneral().getGlobalWaterSpeedModifier() * (this.isAbleToDive() && EntityExtensionsKt.getIsSubmerged((Entity)((Entity)this)) ? this.getServerSettings().getGeneral().getUnderwaterSpeedModifier() : 1.0);
        } else {
            RideableFormData rideableFormData = this.getRideData();
            v4 = mediumModifier = (double)(rideableFormData != null ? rideableFormData.getLandSpeedModifier() : 1.0f) * this.getServerSettings().getGeneral().getGlobalLandSpeedModifier();
        }
        double sprintModifier = this.isSprinting() ? this.getServerSettings().getSprinting().getRideSprintSpeed() / 1.3 : (this.isExhausted ? this.getServerSettings().getSprinting().getExhaustionSpeed() : 1.0);
        RideableFormData rideableFormData = this.getRideData();
        double baseSpeed = this.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.getServerSettings().getGeneral().getGlobalBaseSpeedModifier() * (double)(rideableFormData != null ? rideableFormData.getBaseSpeedModifier() : 1.0f);
        double adjustedSpeed = baseSpeed * (double)mediumSpeed * mediumModifier * speedModifier * sprintModifier;
        return (float)(this.getServerSettings().getGeneral().getRideSpeedLimit() > 0.0 ? Math.min(adjustedSpeed, this.getServerSettings().getGeneral().getRideSpeedLimit() / 43.17) : adjustedSpeed);
    }

    @NotNull
    public Vec3 getFluidFallingAdjustedMovement(double d, boolean bl, @NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"vec3");
        Vec3 vec32 = super.getFluidFallingAdjustedMovement(this.isAbleToDive() && this.isUnderWater() ? 0.0 : d, bl, vec3);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getFluidFallingAdjustedMovement(...)");
        return vec32;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity entityTrackerEntry) {
        Intrinsics.checkNotNullParameter((Object)entityTrackerEntry, (String)"entityTrackerEntry");
        return (Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new SpawnRidePokemonPacket(this, new ClientboundAddEntityPacket((Entity)this, entityTrackerEntry)));
    }

    private static final boolean getOffset$hasOffset(Seat offsets, RiderOffsetType name) {
        return offsets.get((Object)name) != null;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigConstants.SpeedStat.Selection.values().length];
            try {
                nArray[ConfigConstants.SpeedStat.Selection.BASE_SPEED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigConstants.SpeedStat.Selection.BASE_NATURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigConstants.SpeedStat.Selection.BASE_NATURE_VALUES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigConstants.SpeedStat.Selection.TOTAL_SPEED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

