/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common.util;

import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.util.EntityTraceResult;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001d\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\t\u001a-\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0015\u001a'\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0015\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001d\u0010 \u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!\u001aU\u0010+\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\"*\u00020\u0019*\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000&2\n\b\u0002\u0010(\u001a\u0004\u0018\u00018\u00002\b\u0010*\u001a\u0004\u0018\u00010)\u00a2\u0006\u0004\b+\u0010,\u001a[\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010-\"\b\b\u0000\u0010\"*\u00020\u0019*\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000&2\n\b\u0002\u0010(\u001a\u0004\u0018\u00018\u00002\b\u0010*\u001a\u0004\u0018\u00010)\u00a2\u0006\u0004\b.\u0010/\u001aa\u00102\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010-\"\b\b\u0000\u0010\"*\u00020\u0019*\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0010\b\u0002\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0019002\b\u0010*\u001a\u0004\u0018\u00010)\u00a2\u0006\u0004\b2\u00103\u00a8\u00064"}, d2={"", "path", "Lnet/minecraft/resources/ResourceLocation;", "rideableResource", "(Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "", "f1", "f2", "rotLerp", "(FF)F", "lerp", "", "x", "y", "z", "", "decimals", "Lnet/minecraft/world/phys/Vec3;", "roundVec3", "(DDDI)Lnet/minecraft/world/phys/Vec3;", "vec", "(Lnet/minecraft/world/phys/Vec3;I)Lnet/minecraft/world/phys/Vec3;", "Lkotlin/Triple;", "destructVec3", "(Lnet/minecraft/world/phys/Vec3;)Lkotlin/Triple;", "Lnet/minecraft/world/entity/Entity;", "entity", "getDistanceToGround", "(Lnet/minecraft/world/entity/Entity;)D", "Lnet/minecraft/core/particles/SimpleParticleType;", "particle", "", "emitParticle", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/particles/SimpleParticleType;)V", "T", "Lnet/minecraft/world/entity/player/Player;", "maxDistance", "stepDistance", "Ljava/lang/Class;", "entityClass", "ignoreEntity", "Lnet/minecraft/world/level/ClipContext$Fluid;", "collideBlock", "traceEntityCollisionAndReturnRider", "(Lnet/minecraft/world/entity/player/Player;FFLjava/lang/Class;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Fluid;)Lnet/minecraft/world/entity/Entity;", "Lcom/cobblemon/mod/common/util/EntityTraceResult;", "resolveTraceEntityCollision", "(Lnet/minecraft/world/entity/player/Player;FFLjava/lang/Class;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Fluid;)Lcom/cobblemon/mod/common/util/EntityTraceResult;", "", "ignoreEntities", "traceEntityCollisionWithIgnoreList", "(Lnet/minecraft/world/entity/player/Player;FFLjava/lang/Class;Ljava/util/List;Lnet/minecraft/world/level/ClipContext$Fluid;)Lcom/cobblemon/mod/common/util/EntityTraceResult;", "cobbleride-common"})
@SourceDebugExtension(value={"SMAP\nCobbleRideUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleRideUtils.kt\nnet/starliteheart/cobbleride/common/util/CobbleRideUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1#2:179\n2341#3,14:180\n774#3:194\n865#3,2:195\n*S KotlinDebug\n*F\n+ 1 CobbleRideUtils.kt\nnet/starliteheart/cobbleride/common/util/CobbleRideUtilsKt\n*L\n108#1:180,14\n155#1:194\n155#1:195,2\n*E\n"})
public final class CobbleRideUtilsKt {
    @NotNull
    public static final ResourceLocation rideableResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobbleride", (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    public static final float rotLerp(float f1, float f2) {
        return (float)Mth.rotLerp((double)0.5, (double)f2, (double)f1);
    }

    public static final float lerp(float f1, float f2) {
        return (float)Mth.lerp((double)0.5, (double)f2, (double)f1);
    }

    @NotNull
    public static final Vec3 roundVec3(double x, double y, double z, int decimals) {
        return CobbleRideUtilsKt.roundVec3(new Vec3(x, y, z), decimals);
    }

    @NotNull
    public static final Vec3 roundVec3(@NotNull Vec3 vec, int decimals) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        double factor = Math.pow(10.0, decimals);
        return new Vec3(CobbleRideUtilsKt.roundVec3$round(factor, vec.x), CobbleRideUtilsKt.roundVec3$round(factor, vec.y), CobbleRideUtilsKt.roundVec3$round(factor, vec.z));
    }

    @NotNull
    public static final Triple<Double, Double, Double> destructVec3(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return new Triple((Object)vec.x, (Object)vec.y, (Object)vec.z);
    }

    public static final double getDistanceToGround(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        double d = entity.getX();
        double e = entity.getBoundingBox().minY;
        double f = entity.getZ();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.set(d, e, f);
        Level level = entity.level();
        int g = level.getMinBuildHeight();
        while ((double)g < (double)mutableBlockPos.getY()) {
            double h = level.getBlockFloorHeight((BlockPos)mutableBlockPos);
            if (DismountHelper.isBlockFloorValid((double)h)) {
                return e - (double)mutableBlockPos.getY() + h;
            }
            if (level.getFluidState((BlockPos)mutableBlockPos).is(FluidTags.WATER) || level.getFluidState((BlockPos)mutableBlockPos).is(FluidTags.LAVA)) {
                return e - (double)mutableBlockPos.getY() + (double)level.getFluidState((BlockPos)mutableBlockPos).getOwnHeight();
            }
            mutableBlockPos.move(Direction.DOWN);
        }
        return Double.POSITIVE_INFINITY;
    }

    public static final void emitParticle(@NotNull Entity entity, @NotNull SimpleParticleType particle) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        double particleSpeed = entity.getRandom().nextDouble();
        double particleAngle = CobbleRideUtilsKt.emitParticle$getRandomAngle(entity);
        double particleXSpeed = Math.cos(particleAngle) * particleSpeed;
        double particleYSpeed = Math.sin(particleAngle) * particleSpeed;
        if (entity.level() instanceof ServerLevel) {
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ((ServerLevel)level).sendParticles((ParticleOptions)particle, entity.position().x + Math.cos(CobbleRideUtilsKt.emitParticle$getRandomAngle(entity)) * entity.getBoundingBox().getXsize(), entity.getBoundingBox().maxY, entity.position().z + Math.cos(CobbleRideUtilsKt.emitParticle$getRandomAngle(entity)) * entity.getBoundingBox().getZsize(), 1, particleXSpeed, 0.5, particleYSpeed, 1.0);
        }
    }

    @Nullable
    public static final <T extends Entity> T traceEntityCollisionAndReturnRider(@NotNull Player $this$traceEntityCollisionAndReturnRider, float maxDistance, float stepDistance, @NotNull Class<T> entityClass, @Nullable T ignoreEntity, @Nullable ClipContext.Fluid collideBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$traceEntityCollisionAndReturnRider, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Entity entity = PlayerExtensionsKt.traceFirstEntityCollision((Player)$this$traceEntityCollisionAndReturnRider, (float)maxDistance, (float)stepDistance, entityClass, ignoreEntity, (ClipContext.Fluid)collideBlock);
        if (entity != null && entity.isVehicle() && !(entity instanceof Player) && !(entity instanceof NPCEntity)) {
            Entity nextClosest;
            List list;
            if ($this$traceEntityCollisionAndReturnRider.getVehicle() != null) {
                var8_7 = new Entity[]{ignoreEntity, $this$traceEntityCollisionAndReturnRider.getVehicle(), entity};
                list = CollectionsKt.listOf((Object[])var8_7);
            } else {
                var8_7 = new Entity[]{ignoreEntity, entity};
                list = CollectionsKt.listOf((Object[])var8_7);
            }
            List list2 = list;
            EntityTraceResult<T> entityTraceResult = CobbleRideUtilsKt.traceEntityCollisionWithIgnoreList($this$traceEntityCollisionAndReturnRider, maxDistance, stepDistance, entityClass, list2, collideBlock);
            if (entityTraceResult != null) {
                Object v1;
                EntityTraceResult<T> result = entityTraceResult;
                boolean bl = false;
                Iterable $this$minByOrNull$iv = result.getEntities();
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = minElem$iv;
                    } else {
                        Entity it = (Entity)minElem$iv;
                        boolean bl2 = false;
                        float minValue$iv = it.distanceTo((Entity)$this$traceEntityCollisionAndReturnRider);
                        do {
                            Object e$iv = iterator$iv.next();
                            Entity it2 = (Entity)e$iv;
                            $i$a$-minByOrNull-CobbleRideUtilsKt$traceEntityCollisionAndReturnRider$nextClosest$1$1 = false;
                            float v$iv = it2.distanceTo((Entity)$this$traceEntityCollisionAndReturnRider);
                            if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = minElem$iv;
                    }
                }
                v2 = v1;
            } else {
                v2 = nextClosest = null;
            }
            if (nextClosest != null && entity.hasPassenger(nextClosest)) {
                return (T)nextClosest;
            }
        }
        return (T)entity;
    }

    public static /* synthetic */ Entity traceEntityCollisionAndReturnRider$default(Player player, float f, float f2, Class clazz, Entity entity, ClipContext.Fluid fluid, int n, Object object) {
        if ((n & 1) != 0) {
            f = 10.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.05f;
        }
        if ((n & 8) != 0) {
            entity = null;
        }
        return CobbleRideUtilsKt.traceEntityCollisionAndReturnRider(player, f, f2, clazz, entity, fluid);
    }

    @Nullable
    public static final <T extends Entity> EntityTraceResult<T> resolveTraceEntityCollision(@NotNull Player $this$resolveTraceEntityCollision, float maxDistance, float stepDistance, @NotNull Class<T> entityClass, @Nullable T ignoreEntity, @Nullable ClipContext.Fluid collideBlock) {
        EntityTraceResult<T> entityTraceResult;
        Intrinsics.checkNotNullParameter((Object)$this$resolveTraceEntityCollision, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        if ($this$resolveTraceEntityCollision.getVehicle() != null) {
            Object[] objectArray = new Entity[]{ignoreEntity, $this$resolveTraceEntityCollision.getVehicle()};
            List list = CollectionsKt.listOf((Object[])objectArray);
            entityTraceResult = CobbleRideUtilsKt.traceEntityCollisionWithIgnoreList($this$resolveTraceEntityCollision, maxDistance, stepDistance, entityClass, list, collideBlock);
        } else {
            entityTraceResult = PlayerExtensionsKt.traceEntityCollision((Player)$this$resolveTraceEntityCollision, (float)maxDistance, (float)stepDistance, entityClass, ignoreEntity, (ClipContext.Fluid)collideBlock);
        }
        return entityTraceResult;
    }

    public static /* synthetic */ EntityTraceResult resolveTraceEntityCollision$default(Player player, float f, float f2, Class clazz, Entity entity, ClipContext.Fluid fluid, int n, Object object) {
        if ((n & 1) != 0) {
            f = 10.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.05f;
        }
        if ((n & 8) != 0) {
            entity = null;
        }
        return CobbleRideUtilsKt.resolveTraceEntityCollision(player, f, f2, clazz, entity, fluid);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T extends Entity> EntityTraceResult<T> traceEntityCollisionWithIgnoreList(@NotNull Player $this$traceEntityCollisionWithIgnoreList, float maxDistance, float stepDistance, @NotNull Class<T> entityClass, @NotNull List<? extends Entity> ignoreEntities, @Nullable ClipContext.Fluid collideBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$traceEntityCollisionWithIgnoreList, (String)"<this>");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter(ignoreEntities, (String)"ignoreEntities");
        float step = stepDistance;
        Vec3 startPos = $this$traceEntityCollisionWithIgnoreList.getEyePosition();
        Vec3 direction = $this$traceEntityCollisionWithIgnoreList.getLookAngle();
        Vec3 maxDistanceVector = new Vec3(1.0, 1.0, 1.0).scale((double)maxDistance);
        List entities = $this$traceEntityCollisionWithIgnoreList.level().getEntities(null, new AABB(startPos.subtract(maxDistanceVector), startPos.add(maxDistanceVector)), arg_0 -> CobbleRideUtilsKt.traceEntityCollisionWithIgnoreList$lambda$3(arg_0 -> CobbleRideUtilsKt.traceEntityCollisionWithIgnoreList$lambda$2(entityClass, arg_0), arg_0));
        while (step <= maxDistance) {
            void $this$filterTo$iv$iv;
            Vec3 location = startPos.add(direction.scale((double)step));
            step += stepDistance;
            Intrinsics.checkNotNull((Object)entities);
            Iterable $this$filter$iv = entities;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entity it = (Entity)element$iv$iv;
                boolean bl = false;
                if (!(!ignoreEntities.contains(it) && it.getBoundingBox().contains(location) && entityClass.isInstance(it) && !it.isSpectator())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List collided = (List)destination$iv$iv;
            if (!(!((Collection)collided).isEmpty())) continue;
            if (collideBlock != null && $this$traceEntityCollisionWithIgnoreList.level().clip(new ClipContext(startPos, location, ClipContext.Block.COLLIDER, collideBlock, (Entity)$this$traceEntityCollisionWithIgnoreList)).getType() == HitResult.Type.BLOCK) {
                return null;
            }
            Intrinsics.checkNotNull((Object)location);
            return new EntityTraceResult(location, (Iterable)CollectionsKt.filterIsInstance((Iterable)collided, entityClass));
        }
        return null;
    }

    public static /* synthetic */ EntityTraceResult traceEntityCollisionWithIgnoreList$default(Player player, float f, float f2, Class clazz, List list, ClipContext.Fluid fluid, int n, Object object) {
        if ((n & 1) != 0) {
            f = 10.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.05f;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return CobbleRideUtilsKt.traceEntityCollisionWithIgnoreList(player, f, f2, clazz, list, fluid);
    }

    private static final double roundVec3$round(double factor, double x) {
        return (double)MathKt.roundToInt((double)(x * factor)) / factor;
    }

    private static final double emitParticle$getRandomAngle(Entity $entity) {
        return $entity.getRandom().nextDouble() * (double)2 * Math.PI;
    }

    private static final boolean traceEntityCollisionWithIgnoreList$lambda$2(Class $entityClass, Entity it) {
        return $entityClass.isInstance(it);
    }

    private static final boolean traceEntityCollisionWithIgnoreList$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

