/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks;

import com.simibubi.create.foundation.utility.BlockHelper;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class VelvetBlock
extends Block {
    protected final DyeColor color;

    public VelvetBlock(BlockBehaviour.Properties pProperties, DyeColor color) {
        super(pProperties);
        this.color = color;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.1f - level.random.nextFloat() * 0.2f);
            }
            this.applyDye(state, level, pos, hitResult.getLocation(), hitResult.getDirection(), color);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void applyDye(BlockState state, Level world, BlockPos pos, Vec3 hit, Direction direction, @Nullable DyeColor color) {
        BlockState newState = (color == null ? DnDecorBlocks.DYED_VELVET_BLOCKS.get(DyeColor.WHITE) : DnDecorBlocks.DYED_VELVET_BLOCKS.get(color)).getDefaultState();
        if (state != (newState = BlockHelper.copyProperties((BlockState)state, (BlockState)newState))) {
            world.setBlockAndUpdate(pos, newState);
            return;
        }
        List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)hit, (Direction.Axis)direction.getAxis());
        for (Direction d : directions) {
            BlockPos offset = pos.relative(d);
            BlockState adjacentState = world.getBlockState(offset);
            Block block = adjacentState.getBlock();
            if (!(block instanceof VelvetBlock) || state == adjacentState) continue;
            world.setBlockAndUpdate(offset, newState);
            return;
        }
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        frontier.add(pos);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int timeout = 100;
        while (!frontier.isEmpty() && timeout-- >= 0) {
            BlockPos currentPos = (BlockPos)frontier.removeFirst();
            visited.add(currentPos);
            for (Direction d : Iterate.directions) {
                BlockState adjacentState;
                Block block;
                BlockPos offset;
                if (d.getAxis() == direction.getAxis() || visited.contains(offset = currentPos.relative(d)) || !((block = (adjacentState = world.getBlockState(offset)).getBlock()) instanceof VelvetBlock)) continue;
                if (state != adjacentState) {
                    world.setBlockAndUpdate(offset, newState);
                }
                frontier.add(offset);
                visited.add(offset);
            }
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance * 0.1f);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

