/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.beam;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BeamBlock
extends Block
implements IWrenchable {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<BeamStates> BEAM = EnumProperty.create((String)"beam", BeamStates.class);

    public BeamBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.X)).setValue(BEAM, (Comparable)((Object)BeamStates.BOTH)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BeamStates beam = (BeamStates)((Object)state.getValue(BEAM));
        if (face == Direction.UP) {
            beam = beam == BeamStates.TOP ? BeamStates.BOTH : BeamStates.TOP;
        }
        if (face == Direction.DOWN) {
            beam = beam == BeamStates.BOTTOM ? BeamStates.BOTH : BeamStates.BOTTOM;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue(BEAM, (Comparable)((Object)beam))));
        if (level.getBlockState(pos) != state) {
            AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() + 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, BEAM});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        Direction.Axis direction;
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        Direction face = pContext.getClickedFace();
        Direction.Axis axis = direction = face.getAxis().isHorizontal() ? face.getAxis() : pContext.getHorizontalDirection().getAxis();
        if (stateForPlacement != null) {
            stateForPlacement = (BlockState)stateForPlacement.setValue(AXIS, (Comparable)direction);
        }
        return stateForPlacement;
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        return (BlockState)state.setValue(AXIS, (Comparable)rot.rotate(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis)).getAxis());
    }

    public static enum BeamStates implements StringRepresentable
    {
        TOP,
        BOTTOM,
        BOTH;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

