/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.events;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelBlock;
import com.simibubi.create.content.kinetics.flywheel.FlywheelBlock;
import com.simibubi.create.content.kinetics.millstone.MillstoneBlock;
import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndecor.DnDecorUtils;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import dev.lopyluna.dndecor.register.helpers.list_providers.MaterialTypeProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class DnDecorServer {
    @SubscribeEvent
    public static void onItemUseOnBlock(UseItemOnBlockEvent event) {
        Level level = event.getLevel();
        Player player = event.getPlayer();
        BlockPos blockPos = event.getPos();
        BlockState state = level.getBlockState(blockPos);
        Direction face = event.getFace();
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        UseOnContext context = event.getUseOnContext();
        if (event.getUsePhase() == UseItemOnBlockEvent.UsePhase.ITEM_BEFORE_BLOCK) {
            InteractionResult dye;
            if ((stack.is(Tags.Items.DYES) || stack.is(Items.SPONGE)) && (dye = DnDecorServer.dyeUseOn(level, player, state, blockPos, face, hand, stack, context)).consumesAction()) {
                event.cancelWithResult(DnDecorUtils.itemResult(dye));
            }
            Item item = stack.getItem();
            for (NonNullSupplier<Block> type : MaterialTypeProvider.stoneTypes) {
                if (!item.equals(((Block)type.get()).asItem())) continue;
                InteractionResult stone = DnDecorServer.stoneUseOn(type, level, player, state, blockPos, face, hand, stack, context);
                if (!stone.consumesAction()) break;
                event.cancelWithResult(DnDecorUtils.itemResult(stone));
                break;
            }
        }
    }

    public static InteractionResult changeBlock(Level pLevel, BlockPos pPos, BlockState pFrom, BlockState pTo, SoundEvent pSound) {
        return DnDecorServer.changeBlock(pLevel, pPos, pFrom, pTo, pSound, null, false, null);
    }

    public static InteractionResult changeBlock(Level pLevel, BlockPos pPos, BlockState pFrom, BlockState pTo, SoundEvent pSound, SoundEvent pSound2, boolean pParticles, BlockState pParticleState) {
        BlockState newState = BlockHelper.copyProperties((BlockState)pFrom, (BlockState)pTo);
        if (!pFrom.equals(newState)) {
            if (pLevel.setBlockAndUpdate(pPos, newState)) {
                float volume;
                float f = volume = pSound != null && pSound2 != null ? 0.75f : 1.0f;
                if (pSound != null) {
                    pLevel.playSound(null, pPos, pSound, SoundSource.BLOCKS, volume, 1.1f - pLevel.random.nextFloat() * 0.2f);
                }
                if (pSound2 != null) {
                    pLevel.playSound(null, pPos, pSound2, SoundSource.BLOCKS, volume, 1.1f - pLevel.random.nextFloat() * 0.2f);
                }
                if (pParticles && pParticleState != null) {
                    pLevel.addDestroyBlockEffect(pPos, pTo);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult stoneUseOn(NonNullSupplier<Block> type, Level pLevel, Player pPlayer, BlockState pState, BlockPos pPos, Direction pFace, InteractionHand pHand, ItemStack pStack, UseOnContext pContext) {
        BlockState typeState = ((Block)type.get()).defaultBlockState();
        SoundType sound = typeState.getSoundType();
        Block block = pState.getBlock();
        if (block instanceof CrushingWheelBlock) {
            return DnDecorServer.changeBlock(pLevel, pPos, pState, DnDecorBlocks.STONE_TYPE_CRUSHING_WHEELS.get(type).getDefaultState(), sound.getBreakSound(), sound.getPlaceSound(), true, typeState);
        }
        if (block instanceof MillstoneBlock) {
            return DnDecorServer.changeBlock(pLevel, pPos, pState, DnDecorBlocks.STONE_TYPE_MILLSTONE.get(type).getDefaultState(), sound.getBreakSound(), sound.getPlaceSound(), true, typeState);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult dyeUseOn(Level pLevel, Player pPlayer, BlockState pState, BlockPos pPos, Direction pFace, InteractionHand pHand, ItemStack pStack, UseOnContext pContext) {
        Block block = pState.getBlock();
        Item item = pStack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor color = dyeItem.getDyeColor();
            if (block instanceof FlywheelBlock) {
                return DnDecorServer.changeBlock(pLevel, pPos, pState, DnDecorBlocks.DYED_FLYWHEELS.get(color).getDefaultState(), SoundEvents.DYE_USE);
            }
            if (pPlayer.isShiftKeyDown() && block instanceof FlapDisplayBlock) {
                return DnDecorServer.changeBlock(pLevel, pPos, pState, DnDecorBlocks.DYED_DISPLAY_BOARDS.get(color).getDefaultState(), SoundEvents.DYE_USE);
            }
        } else {
            if (block instanceof FlywheelBlock) {
                return DnDecorServer.changeBlock(pLevel, pPos, pState, AllBlocks.FLYWHEEL.getDefaultState(), SoundEvents.SPONGE_ABSORB);
            }
            if (block instanceof FlapDisplayBlock) {
                return DnDecorServer.changeBlock(pLevel, pPos, pState, AllBlocks.DISPLAY_BOARD.getDefaultState(), SoundEvents.SPONGE_ABSORB);
            }
        }
        return InteractionResult.PASS;
    }
}

