/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementClickable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class ElementRightClickable<T extends ElementRightClickable>
extends ElementClickable<T> {
    @NotNull
    public Consumer<T> rightClickCallback;

    public ElementRightClickable(@NotNull Fragment parent, Consumer<T> callback, Consumer<T> rightClickCallback) {
        super(parent, callback);
        this.rightClickCallback = rightClickCallback;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        boolean flag = this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
        ((Fragment)this.parent).setFocused(null);
        if (!this.disabled && this.isMouseOver(mouseX, mouseY)) {
            if (button == 0) {
                this.trigger();
            } else if (button == 1) {
                this.triggerRMB();
            }
        }
        return flag;
    }

    public void triggerRMB() {
        if (this.renderMinecraftStyle() > 0) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        this.onRightClickRelease();
        this.rightClickCallback.accept(this);
    }

    public abstract void onRightClickRelease();

    @Override
    public boolean keyPressed(int key, int scancode, int listener) {
        if (!this.disabled && Screen.hasControlDown() && (key == 32 || key == 257 || key == 335)) {
            this.triggerRMB();
            return true;
        }
        return super.keyPressed(key, scancode, listener);
    }
}

