/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates;

import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import thetestmod.bettercrates.blocks.BaseCrate;
import thetestmod.bettercrates.container.ContainerBase13Rows;
import thetestmod.bettercrates.container.ContainerBase9Rows;
import thetestmod.bettercrates.enums.EnumCrate;
import thetestmod.bettercrates.items.ItemUpgradeBase;
import thetestmod.bettercrates.tile.TileEntityBase;

public class BCRegistry {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"bettercrates");
    private static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"bettercrates");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"bettercrates");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"bettercrates");
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"bettercrates");
    public static DeferredHolder<Block, Block> WOODEN_CRATE = BLOCKS.register(EnumCrate.WOODEN.getName(), () -> new BaseCrate(EnumCrate.WOODEN));
    public static DeferredHolder<Block, Block> IRON_CRATE = BLOCKS.register(EnumCrate.IRON.getName(), () -> new BaseCrate(EnumCrate.IRON));
    public static DeferredHolder<Block, Block> COPPER_CRATE = BLOCKS.register(EnumCrate.COPPER.getName(), () -> new BaseCrate(EnumCrate.COPPER));
    public static DeferredHolder<Block, Block> TIN_CRATE = BLOCKS.register(EnumCrate.TIN.getName(), () -> new BaseCrate(EnumCrate.TIN));
    public static DeferredHolder<Block, Block> GOLDEN_CRATE = BLOCKS.register(EnumCrate.GOLDEN.getName(), () -> new BaseCrate(EnumCrate.GOLDEN));
    public static DeferredHolder<Block, Block> DIAMOND_CRATE = BLOCKS.register(EnumCrate.DIAMOND.getName(), () -> new BaseCrate(EnumCrate.DIAMOND));
    public static DeferredHolder<Block, Block> OBSIDIAN_CRATE = BLOCKS.register(EnumCrate.OBSIDIAN.getName(), () -> new BaseCrate(EnumCrate.OBSIDIAN));
    public static DeferredHolder<Item, Item> UP_WOODEN = ITEMS.register("up_wooden", () -> new ItemUpgradeBase(Blocks.CHEST, ((Block)WOODEN_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_COPPER = ITEMS.register("up_copper", () -> new ItemUpgradeBase(Blocks.CHEST, ((Block)COPPER_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_TIN = ITEMS.register("up_tin", () -> new ItemUpgradeBase(Blocks.CHEST, ((Block)TIN_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_IRON = ITEMS.register("up_iron", () -> new ItemUpgradeBase((Block)WOODEN_CRATE.get(), ((Block)IRON_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_GOLDEN = ITEMS.register("up_golden", () -> new ItemUpgradeBase((Block)IRON_CRATE.get(), ((Block)GOLDEN_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_GOLDEN2 = ITEMS.register("up_golden2", () -> new ItemUpgradeBase((Block)COPPER_CRATE.get(), ((Block)GOLDEN_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_GOLDEN3 = ITEMS.register("up_golden3", () -> new ItemUpgradeBase((Block)TIN_CRATE.get(), ((Block)GOLDEN_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_DIAMOND = ITEMS.register("up_diamond", () -> new ItemUpgradeBase((Block)GOLDEN_CRATE.get(), ((Block)DIAMOND_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<Item, Item> UP_OBSIDIAN = ITEMS.register("up_obsidian", () -> new ItemUpgradeBase((Block)DIAMOND_CRATE.get(), ((Block)OBSIDIAN_CRATE.get()).defaultBlockState()));
    public static DeferredHolder<MenuType<?>, MenuType<ContainerBase9Rows>> CONTAINER_9_ROWS = CONTAINERS.register("container9rows", () -> IMenuTypeExtension.create(ContainerBase9Rows::new));
    public static DeferredHolder<MenuType<?>, MenuType<ContainerBase13Rows>> CONTAINER_13_ROWS = CONTAINERS.register("container13rows", () -> IMenuTypeExtension.create(ContainerBase13Rows::new));
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = TABS.register("bettercrates", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)WOODEN_CRATE.get())).title((Component)Component.translatable((String)"itemGroup.bettercrates")).displayItems((supplier, output) -> ITEMS.getEntries().stream().map(DeferredHolder::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());

    public static void register(IEventBus modEventBus) {
        for (EnumCrate crate : EnumCrate.VALUES) {
            ITEMS.register(crate.getName(), () -> new BlockItem(crate.getBlock(), new Item.Properties().component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)));
            TILE_ENTITIES.register(crate.getName(), crate::getType);
        }
        BLOCKS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ITEMS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        TABS.register(modEventBus);
        modEventBus.addListener(event -> {
            for (EnumCrate crate : EnumCrate.VALUES) {
                event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, side) -> ((TileEntityBase)be).inventory, new Block[]{crate.getBlock()});
            }
        });
    }
}

