/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.container;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import thetestmod.bettercrates.enums.EnumCrate;
import thetestmod.bettercrates.tile.TileEntityBase;

public class ContainerBase
extends AbstractContainerMenu {
    private TileEntityBase tile;
    public EnumCrate enumCrate;

    public ContainerBase(@Nullable MenuType<?> type, int id, Inventory playerInv, BlockPos pos, EnumCrate enumCrate) {
        super(type, id);
        int j;
        int i;
        Level level = playerInv.player.level();
        this.tile = (TileEntityBase)level.getBlockEntity(pos);
        this.enumCrate = enumCrate;
        IItemHandler inventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, level.getBlockState(pos), (BlockEntity)this.tile, null);
        for (i = 0; i < enumCrate.getSlots()[0]; ++i) {
            for (j = 0; j < enumCrate.getSlots()[1]; ++j) {
                this.addSlot((Slot)new SlotItemHandler(inventory, j + i * enumCrate.getSlots()[1], 12 + j * 18, 5 + i * 18){

                    public void setChanged() {
                        ContainerBase.this.tile.setChanged();
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, enumCrate.getSlots()[2] + j * 18, enumCrate.getSlots()[3] + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, enumCrate.getSlots()[4] + k * 18, enumCrate.getSlots()[5]));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.tile.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int containerSlots = this.slots.size() - player.getInventory().items.size();
            if (index < containerSlots ? !this.moveItemStackTo(itemstack1, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

