/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.enums;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import thetestmod.bettercrates.tile.TileEntityBase;
import thetestmod.bettercrates.tile.TileEntityCopperCrate;
import thetestmod.bettercrates.tile.TileEntityDiamondCrate;
import thetestmod.bettercrates.tile.TileEntityGoldenCrate;
import thetestmod.bettercrates.tile.TileEntityIronCrate;
import thetestmod.bettercrates.tile.TileEntityObsidianCrate;
import thetestmod.bettercrates.tile.TileEntityTinCrate;
import thetestmod.bettercrates.tile.TileEntityWoodenCrate;

public enum EnumCrate {
    WOODEN(TileEntityWoodenCrate.class, (BlockEntityType.BlockEntitySupplier<? extends TileEntityBase>)((BlockEntityType.BlockEntitySupplier)TileEntityWoodenCrate::new), "wooden", 5.0f, new int[]{4, 9, 12, 84, 12, 142}, new int[]{184, 166, -12}),
    IRON(TileEntityIronCrate.class, (BlockEntityType.BlockEntitySupplier<? extends TileEntityBase>)((BlockEntityType.BlockEntitySupplier)TileEntityIronCrate::new), "iron", 5.0f, new int[]{7, 9, 12, 138, 12, 196}, new int[]{184, 220, -12}),
    COPPER(TileEntityCopperCrate.class, (BlockEntityType.BlockEntitySupplier<? extends TileEntityBase>)((BlockEntityType.BlockEntitySupplier)TileEntityCopperCrate::new), "copper", 5.0f, new int[]{5, 9, 12, 102, 12, 160}, new int[]{184, 184, -12}),
    TIN(TileEntityTinCrate.class, (BlockEntityType.BlockEntitySupplier<? extends TileEntityBase>)((BlockEntityType.BlockEntitySupplier)TileEntityTinCrate::new), "tin", 5.0f, new int[]{5, 9, 12, 102, 12, 160}, new int[]{184, 184, -12}),
    GOLDEN(TileEntityGoldenCrate.class, (BlockEntityType.BlockEntitySupplier<? extends TileEntityBase>)((BlockEntityType.BlockEntitySupplier)TileEntityGoldenCrate::new), "golden", 5.0f, new int[]{9, 9, 12, 174, 12, 232}, new int[]{184, 256, -12}),
    DIAMOND(TileEntityDiamondCrate.class, (BlockEntityType.BlockEntitySupplier<? extends TileEntityBase>)((BlockEntityType.BlockEntitySupplier)TileEntityDiamondCrate::new), "diamond", 5.0f, new int[]{9, 13, 48, 174, 48, 232}, new int[]{256, 256, -12}),
    OBSIDIAN(TileEntityObsidianCrate.class, (BlockEntityType.BlockEntitySupplier<? extends TileEntityBase>)((BlockEntityType.BlockEntitySupplier)TileEntityObsidianCrate::new), "obsidian", 50.0f, new int[]{9, 13, 48, 174, 48, 232}, new int[]{256, 256, -12});

    public static final EnumCrate[] VALUES;
    private Class<? extends TileEntityBase> tile;
    private BlockEntityType.BlockEntitySupplier<? extends TileEntityBase> supplier;
    private String name;
    private String transKey;
    private ResourceLocation background;
    private Block block;
    private BlockEntityType<? extends TileEntityBase> type;
    private float resistance;
    private int[] slots;
    private int[] size;

    private EnumCrate(Class<? extends TileEntityBase> tile, BlockEntityType.BlockEntitySupplier<? extends TileEntityBase> supplier, String name, float resistance, int[] slots, int[] size) {
        this.tile = tile;
        this.supplier = supplier;
        this.name = name + "_crate";
        this.transKey = "block.bettercrates." + this.name;
        this.background = ResourceLocation.fromNamespaceAndPath((String)"bettercrates", (String)("textures/gui/" + name + "_crate.png"));
        this.resistance = resistance;
        this.slots = slots;
        this.size = size;
    }

    public Class<? extends TileEntityBase> getTile() {
        return this.tile;
    }

    public BlockEntityType.BlockEntitySupplier<? extends TileEntityBase> getSupplier() {
        return this.supplier;
    }

    public String getName() {
        return this.name;
    }

    public String getTransKey() {
        return this.transKey;
    }

    public void setBlock(Block block) {
        this.block = block;
        this.type = BlockEntityType.Builder.of(this.supplier, (Block[])new Block[]{block}).build(null);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockEntityType<? extends TileEntityBase> getType() {
        return this.type;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public float getResistance() {
        return this.resistance;
    }

    public int[] getSlots() {
        return this.slots;
    }

    public int[] getSize() {
        return this.size;
    }

    static {
        VALUES = EnumCrate.values();
    }
}

