/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import thetestmod.bettercrates.tile.CustomItemStackHandler;

public abstract class TileEntityBase
extends BlockEntity {
    public CustomItemStackHandler inventory;

    public TileEntityBase(BlockEntityType<?> type, int size, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new CustomItemStackHandler(size);
    }

    public NonNullList<ItemStack> getInv() {
        return this.inventory.getStacks();
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.writeRestorableToNBT(compound, provider);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.readRestorableFromNBT(compound, provider);
        super.loadAdditional(compound, provider);
    }

    public void readRestorableFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag tag = compound.getCompound("inventory");
        this.inventory.deserializeNBT(provider, tag);
    }

    public void writeRestorableToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("inventory", (Tag)this.inventory.serializeNBT(provider));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        ((ItemContainerContents)pComponentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getInv());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getInv()));
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("inventory");
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }
}

