/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.menu;

import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.client.gui.screen.DynamicMenuButton;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.client.ClientHooks;

public class VanillaLeftTitleScreen
extends TitleScreen
implements TitleScreenBehavior {
    private static final ResourceLocation PANORAMA_OVERLAY = ResourceLocation.withDefaultNamespace((String)"textures/gui/title/background/panorama_overlay.png");
    private final PanoramaRenderer panorama = new PanoramaRenderer(TitleScreen.CUBE_MAP);
    private final boolean showMinceraftEasterEgg = (double)RandomSource.create().nextFloat() < 1.0E-4;

    public VanillaLeftTitleScreen() {
        ((TitleScreenAccessor)((Object)this)).aether$setFading(true);
    }

    protected void init() {
        super.init();
        this.setupButtons();
    }

    public void setupButtons() {
        int buttonCount = 0;
        for (Renderable renderable : this.renderables) {
            Button button;
            Component buttonText;
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget = (AbstractWidget)renderable;
            if (TitleScreenBehavior.isImageButton(abstractWidget.getMessage())) {
                abstractWidget.visible = false;
            }
            if (!(abstractWidget instanceof Button) || !TitleScreenBehavior.isMainButton(buttonText = (button = (Button)abstractWidget).getMessage())) continue;
            button.setX(47);
            button.setY(80 + buttonCount * 25);
            button.setWidth(200);
            ++buttonCount;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)((Object)this);
        if (this.minecraft != null && titleScreenAccessor.aether$getSplash() == null) {
            titleScreenAccessor.aether$setSplash(this.minecraft.getSplashManager().getSplash());
        }
        float fadeAmount = TitleScreenBehavior.super.handleFading(guiGraphics, this, titleScreenAccessor, this.panorama, PANORAMA_OVERLAY, partialTicks);
        this.renderLogo(guiGraphics, fadeAmount);
        int roundedFadeAmount = Mth.ceil((float)(fadeAmount * 255.0f)) << 24;
        if ((roundedFadeAmount & 0xFC000000) != 0) {
            SplashRendererAccessor splashRendererAccessor;
            ClientHooks.renderMainMenu((TitleScreen)this, (GuiGraphics)guiGraphics, (Font)this.font, (int)this.width, (int)this.height, (int)roundedFadeAmount);
            if (titleScreenAccessor.aether$getSplash() != null && (splashRendererAccessor = (SplashRendererAccessor)titleScreenAccessor.aether$getSplash()).cumulus$getSplash() != null && !splashRendererAccessor.cumulus$getSplash().isEmpty()) {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate(250.0f, 50.0f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(-20.0f));
                float textSize = 1.8f - Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                textSize = textSize * 100.0f / (float)(this.font.width(splashRendererAccessor.cumulus$getSplash()) + 32);
                poseStack.scale(textSize, textSize, textSize);
                guiGraphics.drawCenteredString(this.font, splashRendererAccessor.cumulus$getSplash(), 0, -8, 0xFFFF00 | roundedFadeAmount);
                poseStack.popPose();
            }
            TitleScreenBehavior.super.renderRightBranding(guiGraphics, this, this.font, roundedFadeAmount);
        }
        int xOffset = TitleScreenBehavior.super.handleButtonVisibility(this, fadeAmount);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
            if (!(renderable instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)renderable;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        TitleScreenBehavior.super.handleImageButtons(this, xOffset);
    }

    public void renderLogo(GuiGraphics guiGraphics, float transparency) {
        this.renderLogo(guiGraphics, transparency, 30);
    }

    public void renderLogo(GuiGraphics guiGraphics, float transparency, int height) {
        int xOffset = 16;
        int yOffset = -11;
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, transparency);
        guiGraphics.blit(this.showMinceraftEasterEgg ? LogoRenderer.EASTER_EGG_LOGO : LogoRenderer.MINECRAFT_LOGO, xOffset, yOffset + 22, 0.0f, 0.0f, 256, 44, 256, 64);
        guiGraphics.blit(LogoRenderer.MINECRAFT_EDITION, xOffset + 67, height + 37 + yOffset, 0.0f, 0.0f, 128, 14, 128, 16);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

