/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.entity.projectile.weapon.HammerProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class HammerProjectileRenderer
extends EntityRenderer<HammerProjectile> {
    public static final ResourceLocation KINGBDOGZ_WAVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/projectile/kingbdogz_wave.png");
    public static final ResourceLocation JEB_WAVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/projectile/jeb_wave.png");

    public HammerProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.0f;
    }

    public void render(HammerProjectile hammer, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(hammer)));
        HammerProjectileRenderer.vertex(consumer, pose, packedLight, 0.0f, 0.0f, 0.0f, 1.0f);
        HammerProjectileRenderer.vertex(consumer, pose, packedLight, 1.0f, 0.0f, 1.0f, 1.0f);
        HammerProjectileRenderer.vertex(consumer, pose, packedLight, 1.0f, 1.0f, 1.0f, 0.0f);
        HammerProjectileRenderer.vertex(consumer, pose, packedLight, 0.0f, 1.0f, 0.0f, 0.0f);
        poseStack.popPose();
        super.render((Entity)hammer, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float offsetX, float offsetY, float textureX, float textureY) {
        consumer.addVertex(pose, offsetX - 0.5f, offsetY - 0.25f, 0.0f).setColor(-1).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(HammerProjectile hammer) {
        return !hammer.getIsJeb() ? KINGBDOGZ_WAVE_TEXTURE : JEB_WAVE_TEXTURE;
    }
}

