/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.MultiModelRenderer;
import com.aetherteam.aether.client.renderer.entity.layers.ZephyrTransparencyLayer;
import com.aetherteam.aether.client.renderer.entity.model.ClassicZephyrModel;
import com.aetherteam.aether.client.renderer.entity.model.ZephyrModel;
import com.aetherteam.aether.entity.monster.Zephyr;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ZephyrRenderer
extends MultiModelRenderer<Zephyr, EntityModel<Zephyr>, ZephyrModel, ClassicZephyrModel> {
    private static final ResourceLocation ZEPHYR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/zephyr/zephyr.png");
    private static final ResourceLocation ZEPHYR_CLASSIC_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/mobs/zephyr/zephyr_classic.png");
    private final ZephyrModel defaultModel;
    private final ClassicZephyrModel oldModel;

    public ZephyrRenderer(EntityRendererProvider.Context context) {
        super(context, new ZephyrModel(context.bakeLayer(AetherModelLayers.ZEPHYR)), 0.5f);
        this.addLayer(new ZephyrTransparencyLayer((RenderLayerParent<Zephyr, EntityModel<Zephyr>>)this, new ZephyrModel(context.getModelSet().bakeLayer(AetherModelLayers.ZEPHYR_TRANSPARENCY))));
        this.defaultModel = new ZephyrModel(context.bakeLayer(AetherModelLayers.ZEPHYR));
        this.oldModel = new ClassicZephyrModel(context.bakeLayer(AetherModelLayers.ZEPHYR_CLASSIC));
    }

    protected void scale(Zephyr zephyr, PoseStack poseStack, float partialTicks) {
        float f = Math.min(Mth.lerp((float)partialTicks, (float)zephyr.getCloudScale(), (float)(zephyr.getCloudScale() + zephyr.getCloudScaleAdd())), 38.0f);
        float f1 = f / 38.0f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        f1 = 1.0f / ((float)Math.pow(f1, 5.0) * 2.0f + 1.0f);
        float f2 = (8.0f + f1) / 2.0f;
        float f3 = (8.0f + 1.0f / f1) / 2.0f;
        poseStack.scale(f3, f2, f3);
        poseStack.translate(0.0, 0.5, 0.0);
        if (this.getModel() instanceof ClassicZephyrModel) {
            poseStack.scale(0.8f, 0.8f, 0.8f);
            poseStack.translate(0.0, -0.1, 0.0);
        }
    }

    protected float getBob(Zephyr zephyr, float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)zephyr.getTailRot(), (float)(zephyr.getTailRot() + zephyr.getTailRotAdd()));
    }

    @Override
    public ZephyrModel getDefaultModel() {
        return this.defaultModel;
    }

    @Override
    public ClassicZephyrModel getOldModel() {
        return this.oldModel;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return ZEPHYR_TEXTURE;
    }

    @Override
    public ResourceLocation getOldTexture() {
        return ZEPHYR_CLASSIC_TEXTURE;
    }
}

