/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.monster.AechorPlant;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AechorPlantModel
extends EntityModel<AechorPlant> {
    public final ModelPart stem;
    public final ModelPart head;
    public final ModelPart thorn1;
    public final ModelPart thorn2;
    public final ModelPart thorn3;
    public final ModelPart thorn4;
    public final ModelPart stamenStem1;
    public final ModelPart stamenStem2;
    public final ModelPart stamenStem3;
    public final ModelPart stamenTip1;
    public final ModelPart stamenTip2;
    public final ModelPart stamenTip3;
    public final ModelPart leaf1;
    public final ModelPart leaf2;
    public final ModelPart leaf3;
    public final ModelPart leaf4;
    public final ModelPart leaf5;
    public final ModelPart leaf6;
    public final ModelPart leaf7;
    public final ModelPart leaf8;
    public final ModelPart leaf9;
    public final ModelPart leaf10;
    public final ModelPart upperPetal1;
    public final ModelPart upperPetal2;
    public final ModelPart upperPetal3;
    public final ModelPart upperPetal4;
    public final ModelPart upperPetal5;
    public final ModelPart lowerPetal1;
    public final ModelPart lowerPetal2;
    public final ModelPart lowerPetal3;
    public final ModelPart lowerPetal4;
    public final ModelPart lowerPetal5;

    public AechorPlantModel(ModelPart root) {
        this.stem = root.getChild("stem");
        this.head = root.getChild("head");
        this.thorn1 = this.stem.getChild("thorn_1");
        this.thorn2 = this.stem.getChild("thorn_2");
        this.thorn3 = this.stem.getChild("thorn_3");
        this.thorn4 = this.stem.getChild("thorn_4");
        this.stamenStem1 = this.stem.getChild("stamen_stem_1");
        this.stamenStem2 = this.stem.getChild("stamen_stem_2");
        this.stamenStem3 = this.stem.getChild("stamen_stem_3");
        this.stamenTip1 = this.stamenStem1.getChild("stamen_tip_1");
        this.stamenTip2 = this.stamenStem2.getChild("stamen_tip_2");
        this.stamenTip3 = this.stamenStem3.getChild("stamen_tip_3");
        this.leaf1 = this.stem.getChild("leaf_1");
        this.leaf2 = this.stem.getChild("leaf_2");
        this.leaf3 = this.stem.getChild("leaf_3");
        this.leaf4 = this.stem.getChild("leaf_4");
        this.leaf5 = this.stem.getChild("leaf_5");
        this.leaf6 = this.stem.getChild("leaf_6");
        this.leaf7 = this.stem.getChild("leaf_7");
        this.leaf8 = this.stem.getChild("leaf_8");
        this.leaf9 = this.stem.getChild("leaf_9");
        this.leaf10 = this.stem.getChild("leaf_10");
        this.upperPetal1 = this.stem.getChild("upper_petal_1");
        this.upperPetal2 = this.stem.getChild("upper_petal_2");
        this.upperPetal3 = this.stem.getChild("upper_petal_3");
        this.upperPetal4 = this.stem.getChild("upper_petal_4");
        this.upperPetal5 = this.stem.getChild("upper_petal_5");
        this.lowerPetal1 = this.stem.getChild("lower_petal_1");
        this.lowerPetal2 = this.stem.getChild("lower_petal_2");
        this.lowerPetal3 = this.stem.getChild("lower_petal_3");
        this.lowerPetal4 = this.stem.getChild("lower_petal_4");
        this.lowerPetal5 = this.stem.getChild("lower_petal_5");
    }

    public static LayerDefinition createBodyLayer() {
        int i;
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition stem = partDefinition.addOrReplaceChild("stem", CubeListBuilder.create().texOffs(24, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.75f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        stem.addOrReplaceChild("thorn_1", CubeListBuilder.create().texOffs(32, 13).addBox(-1.75f, 1.25f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        stem.addOrReplaceChild("thorn_2", CubeListBuilder.create().texOffs(32, 13).addBox(-1.0f, 2.25f, 0.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        stem.addOrReplaceChild("thorn_3", CubeListBuilder.create().texOffs(32, 13).addBox(0.75f, 1.25f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        stem.addOrReplaceChild("thorn_4", CubeListBuilder.create().texOffs(32, 13).addBox(0.0f, 2.25f, -1.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        PartDefinition stamenStem1 = stem.addOrReplaceChild("stamen_stem_1", CubeListBuilder.create().texOffs(36, 13).addBox(0.0f, -9.0f, -1.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        PartDefinition stamenStem2 = stem.addOrReplaceChild("stamen_stem_2", CubeListBuilder.create().texOffs(36, 13).addBox(0.0f, -9.0f, -1.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        PartDefinition stamenStem3 = stem.addOrReplaceChild("stamen_stem_3", CubeListBuilder.create().texOffs(36, 13).addBox(0.0f, -9.0f, -1.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        stamenStem1.addOrReplaceChild("stamen_tip_1", CubeListBuilder.create().texOffs(32, 15).addBox(0.0f, -9.0f, -1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.ZERO);
        stamenStem2.addOrReplaceChild("stamen_tip_2", CubeListBuilder.create().texOffs(32, 15).addBox(0.0f, -9.0f, -1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.ZERO);
        stamenStem3.addOrReplaceChild("stamen_tip_3", CubeListBuilder.create().texOffs(32, 15).addBox(0.0f, -9.0f, -1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.ZERO);
        for (i = 1; i <= 10; ++i) {
            stem.addOrReplaceChild("leaf_" + i, CubeListBuilder.create().texOffs(38, 13).addBox(-2.0f, -1.0f, -9.5f, 4.0f, 1.0f, 8.0f, new CubeDeformation(-0.15f)), PartPose.ZERO);
        }
        for (i = 1; i <= 5; ++i) {
            stem.addOrReplaceChild("upper_petal_" + i, CubeListBuilder.create().texOffs(28, 2).addBox(-4.0f, -1.0f, -12.0f, 8.0f, 1.0f, 10.0f, new CubeDeformation(-0.25f)), PartPose.ZERO);
        }
        for (i = 1; i <= 5; ++i) {
            stem.addOrReplaceChild("lower_petal_" + i, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.0f, -12.0f, 8.0f, 1.0f, 10.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public Iterable<ModelPart> stamenStemParts() {
        return ImmutableList.of((Object)this.stamenStem1, (Object)this.stamenStem2, (Object)this.stamenStem3);
    }

    public Iterable<ModelPart> leafParts() {
        return ImmutableList.of((Object)this.leaf1, (Object)this.leaf2, (Object)this.leaf3, (Object)this.leaf4, (Object)this.leaf5, (Object)this.leaf6, (Object)this.leaf7, (Object)this.leaf8, (Object)this.leaf9, (Object)this.leaf10);
    }

    public Iterable<ModelPart> petalParts() {
        return ImmutableList.of((Object)this.upperPetal1, (Object)this.lowerPetal1, (Object)this.upperPetal2, (Object)this.lowerPetal2, (Object)this.upperPetal3, (Object)this.lowerPetal3, (Object)this.upperPetal4, (Object)this.lowerPetal4, (Object)this.upperPetal5, (Object)this.lowerPetal5);
    }

    public void setupAnim(AechorPlant aechorPlant, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float sinage2;
        float sinage1 = Mth.sin((float)ageInTicks);
        if (aechorPlant.hurtTime > 0) {
            sinage1 *= 0.45f;
            sinage1 -= 0.125f;
            sinage2 = 1.75f + Mth.sin((float)(ageInTicks + 2.0f)) * 1.5f;
        } else if (aechorPlant.getTargetingEntity()) {
            sinage1 *= 0.25f;
            sinage2 = 1.75f + Mth.sin((float)(ageInTicks + 2.0f)) * 1.5f;
        } else {
            sinage1 *= 0.125f;
            sinage2 = 1.75f;
        }
        this.stem.yRot = this.head.yRot = headPitch / 57.29578f;
        this.stem.y = sinage2 * 0.5f;
        int i = 0;
        for (ModelPart modelPart : this.stamenStemParts()) {
            modelPart.xRot = 0.2f + (float)i / 15.0f;
            modelPart.yRot = this.head.yRot + 0.1f;
            modelPart.yRot += 2.0943952f * (float)i;
            modelPart.xRot += sinage1 * 0.4f;
            modelPart.y = sinage2 + sinage1 * 2.0f;
            ++i;
        }
        i = 0;
        for (ModelPart modelPart : this.leafParts()) {
            modelPart.xRot = i % 2 == 0 ? 0.1f : 0.2f;
            modelPart.xRot += sinage1 * 0.75f;
            modelPart.yRot = this.head.yRot + 0.31415927f;
            modelPart.yRot += 0.62831855f * (float)i;
            modelPart.y = sinage2;
            ++i;
        }
        i = 0;
        for (ModelPart modelPart : this.petalParts()) {
            modelPart.xRot = i % 2 == 0 ? -0.25f : -0.4125f;
            modelPart.xRot += sinage1;
            modelPart.yRot = this.head.yRot;
            modelPart.yRot += 0.62831855f * (float)i;
            modelPart.y = sinage2;
            ++i;
        }
        this.head.y = sinage2 + sinage1 * 2.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int color) {
        this.stem.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, consumer, packedLight, packedOverlay, color);
    }
}

