/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SunSpiritModel<T extends Entity>
extends EntityModel<T> {
    public final ModelPart base;
    public final ModelPart torso;
    public final ModelPart head;
    public final ModelPart rightArm;
    public final ModelPart leftArm;

    public SunSpiritModel(ModelPart root) {
        this.base = root.getChild("base");
        this.torso = this.base.getChild("torso");
        this.head = this.torso.getChild("head");
        this.rightArm = this.torso.getChild("right_arm");
        this.leftArm = this.torso.getChild("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition base = partDefinition.addOrReplaceChild("base", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition torso = base.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(34, 0).addBox(-5.0f, -5.75f, -2.5f, 10.0f, 6.0f, 5.0f, CubeDeformation.NONE).texOffs(34, 11).addBox(-4.5f, 0.25f, -2.0f, 9.0f, 5.0f, 4.0f, CubeDeformation.NONE).texOffs(0, 54).addBox(-4.5f, 5.25f, -2.5f, 9.0f, 1.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.ZERO);
        torso.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 5.0f, 7.0f, CubeDeformation.NONE).texOffs(0, 12).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 3.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-5.75f, (float)0.5f));
        torso.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(20, 33).mirror().addBox(0.5f, 2.5f, -2.5f, 5.0f, 10.0f, 5.0f, CubeDeformation.NONE).mirror(false).texOffs(20, 23).mirror().addBox(0.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.5f)).mirror(false).texOffs(20, 48).addBox(0.5f, 7.5f, -2.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.offset((float)5.0f, (float)-3.75f, (float)0.0f));
        torso.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 23).addBox(-5.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.5f)).texOffs(0, 33).addBox(-5.5f, 2.5f, -2.5f, 5.0f, 10.0f, 5.0f, CubeDeformation.NONE).texOffs(0, 48).mirror().addBox(-5.5f, 7.5f, -2.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)-5.0f, (float)-3.75f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightArm.xRot = -(Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f);
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = -(Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f);
        this.leftArm.xRot = -this.rightArm.xRot;
        this.leftArm.yRot = this.rightArm.yRot;
        this.leftArm.zRot = -this.rightArm.zRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int color) {
        this.base.render(poseStack, consumer, packedLight, packedOverlay, color);
    }
}

