/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.providers;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.construction.AetherFarmBlock;
import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.block.miscellaneous.AetherFrostedIceBlock;
import com.aetherteam.aether.block.miscellaneous.FacingPillarBlock;
import com.aetherteam.aether.block.miscellaneous.UnstableObsidianBlock;
import com.aetherteam.nitrogen.data.providers.NitrogenBlockStateProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class AetherBlockStateProvider
extends NitrogenBlockStateProvider {
    public AetherBlockStateProvider(PackOutput output, String id, ExistingFileHelper helper) {
        super(output, id, helper);
    }

    public void grass(Block block, Block dirtBlock) {
        this.grassBlock(block, block, dirtBlock);
    }

    public void enchantedGrass(Block block, Block grassBlock, Block dirtBlock) {
        this.grassBlock(block, grassBlock, dirtBlock);
    }

    public void grassBlock(Block baseBlock, Block blockForSnow, Block blockForDirt) {
        ModelFile grass = this.grassBlock(baseBlock, blockForDirt);
        ModelFile grassSnowed = this.cubeBottomTop(this.name(blockForSnow) + "_snow", this.extend(this.texture(this.name(blockForSnow), "natural/"), "_snow"), this.texture(this.name(blockForDirt), "natural/"), this.extend(this.texture(this.name(baseBlock), "natural/"), "_top"));
        this.getVariantBuilder(baseBlock).forAllStatesExcept(state -> {
            boolean snowy = (Boolean)state.getValue((Property)SnowyDirtBlock.SNOWY);
            return ConfiguredModel.allYRotations((ModelFile)(snowy ? grassSnowed : grass), (int)0, (boolean)false);
        }, new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public ModelFile grassBlock(Block block, Block dirtBlock) {
        return this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "natural/"), "_side"), this.texture(this.name(dirtBlock), "natural/"), this.extend(this.texture(this.name(block), "natural/"), "_top"));
    }

    public void dirtPath(Block block, Block dirtBlock) {
        ModelBuilder path = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/dirt_path"))).texture("particle", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block) + "_top"))).texture("side", this.modLoc("block/construction/" + this.name(block) + "_side"))).texture("bottom", this.modLoc("block/natural/" + this.name(dirtBlock)));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$dirtPath$1((ModelFile)path, arg_0), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void aercloudAll(Block block, String location) {
        ResourceLocation texture = this.texture(this.name(block), location);
        this.aercloud(block, texture, texture, texture, texture, texture, texture, texture, texture, texture, texture, texture, texture, texture);
    }

    public void aercloud(Block block, ResourceLocation upInside, ResourceLocation upOutside, ResourceLocation downOutside, ResourceLocation downInside, ResourceLocation northOutside, ResourceLocation northInside, ResourceLocation southInside, ResourceLocation southOutside, ResourceLocation westOutside, ResourceLocation westInside, ResourceLocation eastInside, ResourceLocation eastOutside, ResourceLocation particle) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("up_inside", upInside)).texture("up_outside", upOutside)).texture("down_outside", downOutside)).texture("down_inside", downInside)).texture("north_outside", northOutside)).texture("north_inside", northInside)).texture("south_inside", southInside)).texture("south_outside", southOutside)).texture("west_outside", westOutside)).texture("west_inside", westInside)).texture("east_inside", eastInside)).texture("east_outside", eastOutside)).texture("particle", particle)).renderType(ResourceLocation.withDefaultNamespace((String)"translucent"))).element().from(0.0f, 15.998f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#up_inside").uvs(0.0f, 16.0f, 16.0f, 0.0f).cullface(Direction.UP).end().face(Direction.UP).texture("#up_outside").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.UP).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 0.002f, 16.0f).face(Direction.DOWN).texture("#down_outside").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.DOWN).end().face(Direction.UP).texture("#down_inside").uvs(0.0f, 16.0f, 16.0f, 0.0f).cullface(Direction.DOWN).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.002f).face(Direction.NORTH).texture("#north_outside").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#north_inside").uvs(16.0f, 0.0f, 0.0f, 16.0f).cullface(Direction.NORTH).end().end()).element().from(0.0f, 0.0f, 15.998f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#south_inside").uvs(16.0f, 0.0f, 0.0f, 16.0f).cullface(Direction.SOUTH).end().face(Direction.SOUTH).texture("#south_outside").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.SOUTH).end().end()).element().from(0.0f, 0.0f, 0.0f).to(0.002f, 16.0f, 16.0f).face(Direction.WEST).texture("#west_outside").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.WEST).end().face(Direction.EAST).texture("#west_inside").uvs(16.0f, 0.0f, 0.0f, 16.0f).cullface(Direction.WEST).end().end()).element().from(15.998f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.WEST).texture("#east_inside").uvs(16.0f, 0.0f, 0.0f, 16.0f).cullface(Direction.EAST).end().face(Direction.EAST).texture("#east_outside").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.EAST).end().end();
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    public void farmland(Block block, Block dirtBlock) {
        ModelBuilder farmland = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block)));
        ModelBuilder moist = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_moist", this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/natural/" + this.name(dirtBlock)))).texture("top", this.modLoc("block/construction/" + this.name(block) + "_moist"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$farmland$2((ModelFile)farmland, (ModelFile)moist, arg_0), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void randomBlockDoubleDrops(Block block, String location) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.allYRotations((ModelFile)this.cubeAll(block, location), (int)0, (boolean)false), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void blockDoubleDrops(Block block, String location) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cubeAll(block, location)).build(), new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void enchantedLog(RotatedPillarBlock block, RotatedPillarBlock baseBlock) {
        this.axisBlock(block, this.texture(this.name((Block)block), "natural/"), this.extend(this.texture(this.name((Block)baseBlock), "natural/"), "_top"));
    }

    public void altar(Block block) {
        ModelFile altar = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.extend(this.texture(this.name(block), "utility/"), "_bottom"), this.extend(this.texture(this.name(block), "utility/"), "_bottom"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(altar)});
    }

    public void freezer(Block block) {
        ModelFile freezer = this.utility(block);
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(freezer)});
    }

    public void incubator(Block block) {
        ModelFile incubator = this.utility(block);
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(incubator)});
    }

    public ModelFile utility(Block block) {
        return this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.extend(this.texture("altar", "utility/"), "_bottom"), this.extend(this.texture(this.name(block), "utility/"), "_top"));
    }

    public void hangingSignBlock(CeilingHangingSignBlock signBlock, WallHangingSignBlock wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name((Block)signBlock), texture);
        this.simpleBlock((Block)signBlock, (ModelFile)sign);
        this.simpleBlock((Block)wallSignBlock, (ModelFile)sign);
    }

    public void berryBush(Block block, Block stem) {
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(this.bush(block, stem))});
    }

    public ModelFile bush(Block block, Block stem) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("particle", this.texture(this.name(block), "natural/"))).texture("bush", this.texture(this.name(block), "natural/"))).texture("stem", this.texture(this.name(stem), "natural/"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(true).allFaces((direction, builder) -> builder.texture("#bush").end()).end()).element().from(0.8f, 0.0f, 8.0f).to(15.2f, 16.0f, 8.0f).rotation().origin(8.0f, 8.0f, 8.0f).axis(Direction.Axis.Y).angle(45.0f).rescale(true).end().shade(true).face(Direction.NORTH).texture("#stem").end().face(Direction.SOUTH).texture("#stem").end().end()).element().from(8.0f, 0.0f, 0.8f).to(8.0f, 16.0f, 15.2f).rotation().origin(8.0f, 8.0f, 8.0f).axis(Direction.Axis.Y).angle(45.0f).rescale(true).end().shade(true).face(Direction.WEST).texture("#stem").end().face(Direction.EAST).texture("#stem").end().end()).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
    }

    public BlockModelBuilder pottedStemModel(Block block, Block stem, String location) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/block"))).texture("particle", this.mcLoc("block/flower_pot"))).texture("stem", this.modLoc("block/" + location + this.name(stem)))).texture("dirt", this.mcLoc("block/dirt"))).texture("flowerpot", this.mcLoc("block/flower_pot"))).element().from(5.0f, 0.0f, 5.0f).to(6.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(10.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.EAST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(5.0f, 10.0f, 6.0f, 16.0f).texture("#flowerpot").end().face(Direction.WEST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(5.0f, 5.0f, 6.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(5.0f, 5.0f, 6.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(10.0f, 0.0f, 5.0f).to(11.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(5.0f, 10.0f, 6.0f, 16.0f).texture("#flowerpot").end().face(Direction.EAST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(10.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.WEST).uvs(5.0f, 10.0f, 11.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(10.0f, 5.0f, 11.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(10.0f, 5.0f, 11.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 5.0f).to(10.0f, 6.0f, 6.0f).face(Direction.NORTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(6.0f, 5.0f, 10.0f, 6.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(6.0f, 10.0f, 10.0f, 11.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 10.0f).to(10.0f, 6.0f, 11.0f).face(Direction.NORTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.SOUTH).uvs(6.0f, 10.0f, 10.0f, 16.0f).texture("#flowerpot").end().face(Direction.UP).uvs(6.0f, 10.0f, 10.0f, 11.0f).texture("#flowerpot").end().face(Direction.DOWN).uvs(6.0f, 5.0f, 10.0f, 6.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(6.0f, 0.0f, 6.0f).to(10.0f, 4.0f, 10.0f).face(Direction.UP).uvs(6.0f, 6.0f, 10.0f, 10.0f).texture("#dirt").end().face(Direction.DOWN).uvs(6.0f, 12.0f, 10.0f, 16.0f).texture("#flowerpot").cullface(Direction.DOWN).end().end()).element().from(7.0f, 4.0f, 8.0f).to(9.0f, 6.0f, 8.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.NORTH).uvs(7.0f, 14.0f, 9.0f, 16.0f).texture("#stem").end().face(Direction.SOUTH).uvs(7.0f, 14.0f, 9.0f, 16.0f).texture("#stem").end().end()).element().from(1.0f, 6.0f, 8.0f).to(15.0f, 16.0f, 8.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.NORTH).uvs(1.0f, 4.0f, 15.0f, 14.0f).texture("#stem").end().face(Direction.SOUTH).uvs(1.0f, 4.0f, 15.0f, 14.0f).texture("#stem").end().end()).element().from(8.0f, 4.0f, 7.0f).to(8.0f, 6.0f, 9.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.EAST).uvs(7.0f, 14.0f, 9.0f, 16.0f).texture("#stem").end().face(Direction.WEST).uvs(7.0f, 14.0f, 9.0f, 16.0f).texture("#stem").end().end()).element().from(8.0f, 6.0f, 1.0f).to(8.0f, 16.0f, 15.0f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 8.0f).end().face(Direction.EAST).uvs(1.0f, 4.0f, 15.0f, 14.0f).texture("#stem").end().face(Direction.WEST).uvs(1.0f, 4.0f, 15.0f, 14.0f).texture("#stem").end().end();
    }

    public void pottedStem(Block stem, String location) {
        ModelBuilder pot = this.pottedStemModel(stem, stem, location).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
        this.getVariantBuilder(stem).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void pottedBush(Block bush, Block stem, String location) {
        ModelBuilder pot = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.pottedStemModel(bush, stem, location).texture("stem", this.modLoc("block/" + location + this.name(stem)))).texture("bush", this.modLoc("block/" + location + this.name(bush)))).element().from(3.0f, 6.0f, 3.0f).to(13.0f, 16.0f, 13.0f).face(Direction.NORTH).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.EAST).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.SOUTH).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.WEST).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.UP).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().face(Direction.DOWN).uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#bush").end().end()).renderType(ResourceLocation.withDefaultNamespace((String)"cutout"));
        this.getVariantBuilder(bush).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pot)});
    }

    public void dungeonBlock(Block block, Block baseBlock) {
        ConfiguredModel dungeonBlock = new ConfiguredModel((ModelFile)this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock), "dungeon/")));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{dungeonBlock});
    }

    public void invisibleBlock(Block block, Block baseBlock) {
        ModelBuilder visible = this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock), "dungeon/"));
        ModelBuilder invisible = this.models().getBuilder(this.name(block));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$invisibleBlock$6((ModelFile)visible, (ModelFile)invisible, arg_0), new Property[0]);
    }

    public void chestMimic(Block block, Block dummyBlock) {
        ModelBuilder chest = this.models().cubeAll(this.name(block), this.mcLoc("block/" + this.name(dummyBlock)));
        this.chest(block, (ModelFile)chest);
    }

    public void treasureChest(Block block, Block dummyBlock) {
        ModelBuilder chest = this.models().cubeAll(this.name(block), this.texture(this.name(dummyBlock), "dungeon/"));
        this.chest(block, (ModelFile)chest);
    }

    public void pillar(RotatedPillarBlock block) {
        this.axisBlock(block, this.extend(this.texture(this.name((Block)block), "dungeon/"), "_side"), this.extend(this.texture(this.name((Block)block), "dungeon/"), "_top"));
    }

    public void pillarTop(FacingPillarBlock block) {
        ResourceLocation side = this.texture("pillar_carved", "dungeon/");
        ResourceLocation end = this.texture(this.name((Block)block), "dungeon/");
        ModelBuilder vertical = this.models().cubeColumn(this.name((Block)block), side, end);
        ModelBuilder horizontal = this.models().cubeColumnHorizontal(this.name((Block)block) + "_horizontal", side, end);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)FacingPillarBlock.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)vertical).rotationX(180).addModel()).partialState().with((Property)FacingPillarBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(90).addModel()).partialState().with((Property)FacingPillarBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)horizontal).rotationX(90).addModel()).partialState().with((Property)FacingPillarBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(180).addModel()).partialState().with((Property)FacingPillarBlock.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)vertical).addModel()).partialState().with((Property)FacingPillarBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(270).addModel();
    }

    public void present(Block block) {
        ModelFile present = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "miscellaneous/"), "_side"), this.extend(this.texture(this.name(block), "miscellaneous/"), "_top"), this.extend(this.texture(this.name(block), "miscellaneous/"), "_top"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(present)});
    }

    public void sunAltar(Block block) {
        ModelFile sunAltar = this.cubeBottomTop(this.name(block), this.extend(this.texture(this.name(block), "utility/"), "_side"), this.texture("hellfire_stone", "dungeon/"), this.extend(this.texture(this.name(block), "utility/"), "_top"));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel(sunAltar)});
    }

    public void bed(Block block, Block dummyBlock) {
        ModelBuilder head = this.models().cubeAll(this.name(block) + "_head", this.texture(this.name(dummyBlock), "construction/"));
        ModelBuilder foot = this.models().cubeAll(this.name(block) + "_foot", this.texture(this.name(dummyBlock), "construction/"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AetherBlockStateProvider.lambda$bed$7((ModelFile)head, (ModelFile)foot, arg_0), new Property[]{BedBlock.OCCUPIED});
    }

    public void frostedIce(Block block, Block base) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)AetherFrostedIceBlock.AGE);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_" + age, this.mcLoc("block/" + this.name(base) + "_" + age))).renderType(ResourceLocation.withDefaultNamespace((String)"translucent"))).build();
        });
    }

    public void unstableObsidian(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)UnstableObsidianBlock.AGE);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_" + age, this.texture(this.name(block) + "_" + age, "miscellaneous/"))).build();
        });
    }

    private static /* synthetic */ ConfiguredModel[] lambda$bed$7(ModelFile head, ModelFile foot, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BedPart part = (BedPart)state.getValue((Property)BlockStateProperties.BED_PART);
        return ConfiguredModel.builder().modelFile(part == BedPart.HEAD ? head : foot).rotationY(((int)dir.toYRot() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$invisibleBlock$6(ModelFile visible, ModelFile invisible, BlockState state) {
        if (!((Boolean)state.getValue((Property)DoorwayBlock.INVISIBLE)).booleanValue()) {
            return ConfiguredModel.builder().modelFile(visible).build();
        }
        return ConfiguredModel.builder().modelFile(invisible).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$farmland$2(ModelFile farmland, ModelFile moist, BlockState state) {
        int moisture = (Integer)state.getValue((Property)AetherFarmBlock.MOISTURE);
        return ConfiguredModel.builder().modelFile(moisture < 7 ? farmland : moist).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$dirtPath$1(ModelFile path, BlockState state) {
        return ConfiguredModel.allYRotations((ModelFile)path, (int)0, (boolean)false);
    }
}

