/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.ai.goal.MostDamageTargetGoal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.event.ValkyrieTeleportEvent;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractValkyrie
extends Monster
implements NotGrounded {
    private static final EntityDataAccessor<Boolean> DATA_ENTITY_ON_GROUND_ID = SynchedEntityData.defineId(AbstractValkyrie.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private MostDamageTargetGoal mostDamageTargetGoal;
    private int lungeCooldown = 0;
    protected double lastMotionY;

    public AbstractValkyrie(EntityType<? extends AbstractValkyrie> type, Level level) {
        super(type, level);
        this.moveControl = new ValkyrieMoveControl((Mob)this);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ValkyrieTeleportGoal(this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.65, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 8.0f));
        this.mostDamageTargetGoal = new MostDamageTargetGoal((Mob)this);
        this.targetSelector.addGoal(1, (Goal)this.mostDamageTargetGoal);
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ENTITY_ON_GROUND_ID, (Object)true);
    }

    public void tick() {
        super.tick();
        if (this.onGround()) {
            this.setEntityOnGround(true);
        }
        if (!this.level().isClientSide() && this.lungeCooldown > 0) {
            --this.lungeCooldown;
        }
    }

    public void travel(Vec3 motion) {
        this.lastMotionY = this.getDeltaMovement().y();
        super.travel(motion);
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        this.setEntityOnGround(false);
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        boolean result = super.hurt(source, amount);
        if (!this.level().isClientSide() && result && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.mostDamageTargetGoal.addAggro(living, amount);
        }
        return result;
    }

    protected boolean teleportAroundTarget(Entity target) {
        Vec2 targetVec = new Vec2(this.getRandom().nextFloat() - 0.5f, this.getRandom().nextFloat() - 0.5f).normalized();
        double x = target.getX() + (double)(targetVec.x * 3.0f);
        double y = target.getY();
        double z = target.getZ() + (double)(targetVec.y * 3.0f);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        for (int i = 0; mutableBlockPos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)mutableBlockPos).blocksMotion() && i <= 4; ++i) {
            mutableBlockPos.move(Direction.DOWN);
        }
        BlockState blockState = this.level().getBlockState((BlockPos)mutableBlockPos);
        boolean isValidSpot = blockState.is(AetherTags.Blocks.VALKYRIE_TELEPORTABLE_ON);
        return isValidSpot && this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        ValkyrieTeleportEvent event = AetherEventDispatch.onValkyrieTeleport((LivingEntity)this, x, y, z);
        if (event.isCanceled()) {
            return false;
        }
        boolean flag = this.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (flag) {
            this.spawnExplosionParticles();
        }
        return flag;
    }

    public void spawnExplosionParticles() {
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)70);
        }
    }

    protected void chat(Player player, Component message, boolean sound) {
        player.sendSystemMessage(message);
    }

    @Override
    public boolean isEntityOnGround() {
        return (Boolean)this.getEntityData().get(DATA_ENTITY_ON_GROUND_ID);
    }

    @Override
    public void setEntityOnGround(boolean onGround) {
        this.getEntityData().set(DATA_ENTITY_ON_GROUND_ID, (Object)onGround);
    }

    protected float getFlyingSpeed() {
        return this.getSpeed() * 0.216f;
    }

    protected boolean canRide(Entity vehicle) {
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public void handleEntityEvent(byte id) {
        if (id == 70) {
            for (int i = 0; i < 5; ++i) {
                EntityUtil.spawnMovementExplosionParticles((Entity)this);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public static class ValkyrieMoveControl
    extends MoveControl {
        public ValkyrieMoveControl(Mob pMob) {
            super(pMob);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.JUMPING) {
                this.operation = MoveControl.Operation.MOVE_TO;
            }
            super.tick();
        }
    }

    public static class ValkyrieTeleportGoal
    extends Goal {
        private final AbstractValkyrie valkyrie;
        protected int teleportTimer;

        public ValkyrieTeleportGoal(AbstractValkyrie valkyrie) {
            this.valkyrie = valkyrie;
            this.teleportTimer = this.valkyrie.getRandom().nextInt(200);
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            if (this.teleportTimer++ < 450) {
                return;
            }
            this.teleportTimer = this.valkyrie.getTarget() != null && this.valkyrie.teleportAroundTarget((Entity)this.valkyrie.getTarget()) ? this.valkyrie.getRandom().nextInt(40) : (this.teleportTimer -= 20);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    public static class LungeGoal
    extends Goal {
        private final AbstractValkyrie valkyrie;
        private final double speedModifier;
        private final int lungeCooldownMax;
        private int flyingTicks;

        public LungeGoal(AbstractValkyrie valkyrie, double speedModifier, int lungeCooldownMax) {
            this.valkyrie = valkyrie;
            this.speedModifier = speedModifier;
            this.lungeCooldownMax = lungeCooldownMax;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.valkyrie.onGround() && this.valkyrie.lungeCooldown <= 0;
        }

        public void tick() {
            LivingEntity target = this.valkyrie.getTarget();
            double motionY = this.valkyrie.getDeltaMovement().y();
            if (target != null) {
                if (motionY < 0.2 && this.valkyrie.lastMotionY >= 0.2 && this.valkyrie.distanceTo((Entity)target) <= 16.0f) {
                    double x = target.getX() - this.valkyrie.getX();
                    double z = target.getZ() - this.valkyrie.getZ();
                    double angle = Math.atan2(x, z);
                    this.valkyrie.setDeltaMovement(Math.sin(angle) * 0.3, motionY -= 0.1, Math.cos(angle) * 0.3);
                    this.valkyrie.setYRot((float)angle * 57.295776f);
                    this.flyingTicks = 8;
                }
                if (this.flyingTicks > 0) {
                    --this.flyingTicks;
                    AttributeInstance gravity = this.valkyrie.getAttribute(Attributes.GRAVITY);
                    double fallSpeed = gravity != null ? Math.max(gravity.getValue() * -0.625, -0.275) : -0.275;
                    if (motionY < fallSpeed) {
                        this.valkyrie.setDeltaMovement(this.valkyrie.getDeltaMovement().x(), fallSpeed, this.valkyrie.getDeltaMovement().z());
                        this.valkyrie.setEntityOnGround(false);
                    }
                }
                Vec3 position = target.position();
                this.valkyrie.getMoveControl().setWantedPosition(position.x(), position.y(), position.z(), this.speedModifier);
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void stop() {
            this.valkyrie.lungeCooldown = this.lungeCooldownMax;
        }
    }
}

