/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners;

import com.aetherteam.aether.event.hooks.EntityHooks;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.events.OnDeathCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.living.MobSplitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class EntityListener {
    public static void listen(IEventBus bus) {
        bus.addListener(EntityListener::onEntityJoin);
        bus.addListener(EntityListener::onMountEntity);
        bus.addListener(EntityListener::onRiderTick);
        bus.addListener(EntityListener::onInteractWithEntity);
        bus.addListener(EntityListener::onProjectileHitEntity);
        bus.addListener(EntityListener::onShieldBlock);
        bus.addListener(EntityListener::onLightningStrike);
        bus.addListener(EntityListener::onPlayerDrops);
        bus.addListener(EntityListener::onDropExperience);
        bus.addListener(EntityListener::onEffectApply);
        bus.addListener(EntityListener::onEntitySplit);
        bus.addListener(EntityListener::onLoadPlayerFile);
        OnDeathCallback.EVENT.register((currentState, entity, capability, damageSource, droppedStacks) -> {
            ArrayList<ItemStack> droppedStacksCopy = new ArrayList<ItemStack>(droppedStacks);
            boolean recentlyHit = entity.hurtMarked;
            int looting = EnchantmentHelper.getEnchantmentLevel((Holder)entity.level().registryAccess().holderOrThrow(Enchantments.LOOTING), (LivingEntity)entity);
            droppedStacks.clear();
            droppedStacks.addAll(EntityHooks.handleEntityAccessoryDrops(entity, droppedStacksCopy, recentlyHit, looting));
            return TriState.DEFAULT;
        });
    }

    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        EntityHooks.addGoals(entity);
    }

    public static void onMountEntity(EntityMountEvent event) {
        boolean isDismounting;
        Entity mountEntity;
        Entity riderEntity = event.getEntityMounting();
        if (EntityHooks.dismountPrevention(riderEntity, mountEntity = event.getEntityBeingMounted(), isDismounting = event.isDismounting())) {
            event.setCanceled(true);
        } else {
            EntityHooks.trackMount(mountEntity, isDismounting);
        }
    }

    public static void onRiderTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        EntityHooks.launchMount(player);
    }

    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity targetEntity = event.getTarget();
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        Vec3 position = event.getLocalPos();
        InteractionHand interactionHand = event.getHand();
        EntityHooks.skyrootBucketMilking(targetEntity, player, interactionHand);
        Optional<InteractionResult> result = EntityHooks.pickupBucketable(targetEntity, player, interactionHand);
        if (result.isEmpty()) {
            result = EntityHooks.interactWithArmorStand(targetEntity, player, itemStack, position, interactionHand);
        }
        result.ifPresent(arg_0 -> ((PlayerInteractEvent.EntityInteractSpecific)event).setCancellationResult(arg_0));
        event.setCanceled(result.isPresent());
    }

    public static void onProjectileHitEntity(ProjectileImpactEvent event) {
        HitResult rayTraceResult;
        Entity projectileEntity = event.getEntity();
        if (EntityHooks.preventEntityHooked(projectileEntity, rayTraceResult = event.getRayTraceResult())) {
            event.setCanceled(true);
        }
    }

    public static void onShieldBlock(LivingShieldBlockEvent event) {
        if (!event.isCanceled()) {
            event.setCanceled(EntityHooks.preventSliderShieldBlock(event.getDamageSource()));
        }
    }

    public static void onLightningStrike(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        LightningBolt lightningBolt = event.getLightning();
        if (EntityHooks.lightningHitKeys(entity) || EntityHooks.thunderCrystalHitItems(entity, lightningBolt)) {
            event.setCanceled(true);
        }
    }

    public static void onPlayerDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Collection itemDrops = event.getDrops();
        EntityHooks.trackDrops(entity, itemDrops);
    }

    public static void onDropExperience(LivingExperienceDropEvent event) {
        LivingEntity livingEntity = event.getEntity();
        int experience = event.getDroppedExperience();
        int newExperience = EntityHooks.modifyExperience(livingEntity, experience);
        event.setDroppedExperience(newExperience);
    }

    public static void onEffectApply(MobEffectEvent.Applicable event) {
        MobEffectInstance effectInstance;
        LivingEntity livingEntity = event.getEntity();
        if (EntityHooks.preventInebriation(livingEntity, effectInstance = event.getEffectInstance())) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    public static void onEntitySplit(MobSplitEvent event) {
        Mob mob = event.getParent();
        if (EntityHooks.preventSplit(mob)) {
            event.setCanceled(true);
        }
    }

    public static void onLoadPlayerFile(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag playerTag = serverPlayer.server.getWorldData().getLoadedPlayerTag();
            if (playerTag == null) {
                return;
            }
            Optional<CompoundTag> capsTag = EntityListener.tryGetCapsTag(playerTag);
            if (capsTag.isEmpty()) {
                return;
            }
            CompoundTag curiosInventoryTag = capsTag.get().getCompound("curios:inventory");
            if (curiosInventoryTag.getBoolean("AccessoriesEncoded") || !curiosInventoryTag.contains("Curios")) {
                return;
            }
            Tag curiosTag = curiosInventoryTag.get("Curios");
            if (curiosTag instanceof ListTag) {
                ListTag curiosListTag = (ListTag)curiosTag;
                for (Tag tag : curiosListTag) {
                    Tag itemsTag;
                    CompoundTag stacksTag;
                    CompoundTag stacksHandlerTag;
                    CompoundTag compoundTag;
                    if (!(tag instanceof CompoundTag) || !(compoundTag = (CompoundTag)tag).contains("StacksHandler") || !compoundTag.contains("Identifier") || !(stacksHandlerTag = compoundTag.getCompound("StacksHandler")).contains("Stacks") || !(stacksTag = stacksHandlerTag.getCompound("Stacks")).contains("Items") || !((itemsTag = stacksTag.get("Items")) instanceof ListTag)) continue;
                    ListTag listTag = (ListTag)itemsTag;
                    for (Tag itemTag : listTag) {
                        Item item;
                        ResourceLocation location;
                        CompoundTag itemCompoundTag;
                        if (!(itemTag instanceof CompoundTag) || !(itemCompoundTag = (CompoundTag)itemTag).contains("id") || !(location = ResourceLocation.parse((String)itemCompoundTag.getString("id"))).getNamespace().equals("aether") || (item = (Item)BuiltInRegistries.ITEM.get(location)) == Items.AIR) continue;
                        ItemStack stack = new ItemStack((ItemLike)item);
                        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
                        if (accessories == null) continue;
                        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory((ItemStack)stack);
                        Pair equipReference = accessories.canEquipAccessory(stack, true);
                        if (equipReference == null || !accessory.canEquip(stack, (SlotReference)equipReference.first())) continue;
                        ((EquipAction)equipReference.second()).equipStack(stack.copy());
                    }
                }
            }
        }
    }

    private static Optional<CompoundTag> tryGetCapsTag(CompoundTag playerTag) {
        if (playerTag == null) {
            return Optional.empty();
        }
        CompoundTag capsTag = null;
        if (playerTag.contains("ForgeCaps")) {
            capsTag = playerTag.getCompound("ForgeCaps");
        } else if (playerTag.contains("neoforge:attachments")) {
            capsTag = playerTag.getCompound("neoforge:attachments");
        } else {
            return Optional.empty();
        }
        return capsTag.contains("curios:inventory") ? Optional.of(capsTag) : Optional.empty();
    }
}

