/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei.categories;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public interface BiomeTooltip {
    default public void populateBiomeInformation(@Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, List<Component> tooltip) {
        if (Minecraft.getInstance().level != null && (biomeKey != null || biomeTag != null)) {
            tooltip.add((Component)Component.translatable((String)"gui.aether.jei.biome.tooltip").withStyle(ChatFormatting.GRAY));
            if (biomeKey != null) {
                tooltip.add((Component)Component.translatable((String)"gui.aether.jei.biome.tooltip.biome").withStyle(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.literal((String)biomeKey.location().toString()).withStyle(ChatFormatting.DARK_GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"gui.aether.jei.biome.tooltip.tag").withStyle(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.literal((String)("#" + String.valueOf(biomeTag.location()))).withStyle(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.translatable((String)"gui.aether.jei.biome.tooltip.biomes").withStyle(ChatFormatting.DARK_GRAY));
                Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getTagOrEmpty(biomeTag).forEach(biomeHolder -> biomeHolder.unwrapKey().ifPresent(key -> tooltip.add((Component)Component.literal((String)key.location().toString()).withStyle(ChatFormatting.DARK_GRAY))));
            }
        }
    }
}

